<?php
function smarty_modifier_item_link($string) {

	// URL
	$string = preg_replace("/\[\[(.+?)&gt;(http:\/\/.+?)\]\]/",'<a href="$2" title="ɽ">$1<img src="/img/common/web_link.gif" width="14" height="14" class="link-icon" /></a>',$string);

	while(preg_match("/\[\[(http:\/\/.+?)\]\]/", $string, $matches)) {
		$url = $matches[1];
		if(strlen($url)>30) {
			$keyword = substr($url, 0, 30).'...';
		} else {
			$keyword = $url;
		}
		$replace_word = '<a href="'.$url.'" title="ɽ">'.$keyword.'</a>';
		$replace_word .= '<img src="/img/common/web_link.gif" width="14" height="14" class="link-icon" /></a>';
		$string = str_replace($matches[0], $replace_word, $string);
	}

	
	// search item
	while(preg_match("/(.+?)/", $string, $matches)) {
		$keyword = $matches[1];
		$encoding = mb_detect_encoding($keyword, "ASCII,EUC-JP,UTF-8");
		if($encoding=='EUC-JP' OR $encoding=='UTF-8') {
			$escaped = urlencode($keyword);
		} else {
			$escaped = str_replace(' ', '%20', $keyword);
		}
		$replace_word = '<a href="/item/index1.html?keyword='.$escaped.'&amp;kind=name" title="item̾Ǹ">'.$keyword;
		$replace_word .= '<img src="/img/common/item_link.gif" width="14" height="14" class="link-icon" /></a>';
		$string = str_replace($matches[0], $replace_word, $string);
	}


	// search by google
	while(preg_match("/(.+?)/", $string, $matches)) {
		$keyword = $matches[1];
		$encoding = mb_detect_encoding($keyword, "ASCII,EUC-JP,UTF-8");
		if($encoding=='EUC-JP' OR $encoding=='UTF-8') {
			$escaped = urlencode($keyword);
		} else {
			$escaped = urlencode($keyword);
		}
		$replace_word = '<a href="http://www.google.co.jp/search?site=searchl&amp;hl=ja&amp;inlang=ja&amp;ie=EUC-JP&amp;oe=EUC-JP&amp;q='.$escaped.'" title="GoogleǸ">'.$keyword;
		$replace_word .= '<img src="/img/common/google_link.gif" width="14" height="14" class="link-icon" /></a>';
		$string = str_replace($matches[0], $replace_word, $string);
	}

	// link to wikipedia
	while(preg_match("/(.+?)/", $string, $matches)) {
		$keyword = $matches[1];
		$encoding = mb_detect_encoding($keyword, "ASCII,EUC-JP,UTF-8");
		if($encoding=='EUC-JP') {
			$escaped = urlencode(mb_convert_encoding($keyword, 'UTF-8', 'EUC-JP'));
			$escaped = str_replace('%26%23039%3B',"'",$escaped);
		} elseif($encoding=='UTF-8') {
			$escaped = urlencode($keyword);
			$escaped = str_replace('%26%23039%3B',"'",$escaped);
		} else {
			$escaped = $keyword;
		}
		$replace_word = '<a href="http://ja.wikipedia.org/wiki/'.$escaped.'" title="Wikipediaɽ">'.$keyword;
		$replace_word .= '<img src="/img/common/wiki_link.gif" width="14" height="14" class="link-icon" /></a>';
		$string = str_replace($matches[0], $replace_word, $string);
	}


	return $string;
}


?>
