<?php
/**
 * Smarty mgq function plugin
 * Old name is make_get_query
 *
 * Type:     function<br>
 * Name:     mgq<br>
 * Purpose:  Build url query string from $_GET super global variable array.
 *           And replace values via specific query strings.
 * @link http://quicty.zubapita.jp/
 *          mb_truncate (Quicty online manual)
 * @author   Tomoyuki Negishi <tomoyu-n at zubapita dot jp>
 * @param array
 * @param object
 */
function smarty_function_mgq($params,$smarty) {
	$get_params = array();

	if(count($_GET)) {
		foreach($_GET as $key=>$values) {
			if($key=='pageID') continue;
			if($key=='PHPSESSID') continue;
			if($key=='keyword') continue;
			if($key=='kind') continue;
			$get_params[$key] = $values;
		}
	}
	
	if(count($params)) {
		foreach($params as $key=>$values) {
			$get_params[$key] = $values;
		}
	}
	$query_string = http_build_query($get_params,NULL,'&amp;');
	if($query_string) $query_string = '?'.$query_string;
	return $query_string;
}
?>
