<?php
require_once 'skin_classes/_base.class.php';
class skin extends skin_base {


function dispatch_add() {
	$this->application['id'] = $_REQUEST['application_id'];
	$application_obj = $this->new_data_set('application');
	$application = $application_obj->select_table('where id='.$this->application['id']);
	$application_root = $application[0]['application_root'];
	$skin_def_file =  $application_root.'/etc/conf/skin.conf';
	if(file_exists($skin_def_file)) {
		$config = new Config();
		$skin_def_obj = $config->parseConfig($skin_def_file,'inifile');
		$skin_def_array = $skin_def_obj->toArray();
		$this->layout = $skin_def_array['root']['skin']['layout'];
		$this->assign('layout',$this->layout);
		$this->color = $skin_def_array['root']['skin']['color'];
		$color_name = array_pop(explode('_',$this->color));
		$this->assign('color',$color_name);
	}

	$result = $this->display_record();
	if($this->QuictyStatus=='INSERT') {
		$layout = $_POST['layout'];
		$color = $_POST['color'];

		$skin_def = <<<EOS
[skin]
layout = $layout
color = $color
EOS;
		file_put_contents($skin_def_file,$skin_def);

		$importer_css_file = $application_root.'/htdocs/css/importer.css';
		$importer_css = $this->get_importer_css($layout,$color);
		file_put_contents($importer_css_file,$importer_css);
		$importer_js_file = $application_root.'/htdocs/js/import_js.inc';
		$importer_js = $this->get_importer_js($layout);
		file_put_contents($importer_js_file,$importer_js);

		redirect('/info?id='.$_POST['application_id']);
	}
	
	$this->assign_form('input_form',$this->form);
	$this->page['name'] = '쥤Ȥȥ顼ѹ';
	$this->assign_page_and_pathlist();
	return $this->display($this->current_template);
}

function get_importer_css($layout,$color) {
	$importer_css = <<<EOS
@import "tag_basic.css";
@import "font_basic.css";
@import "common_parts.css";
@import "$layout.css";
/* for ../js/layout_2col.js 
@import "2col_liquid_right.css";
@import "2col_liquid_left.css";
@import "2col_775px_right.css";
@import "2col_775px_left.css";
*/
/* for ../js/layout_3col.js
@import "3col_975px.css";
*/
/* for ../js/layout_2_1col.js
@import "2_1col_975px.css";
*/
@import "$color.css";
/*
@import "decoration_pink.css";
@import "decoration_blue.css";
@import "decoration_green.css";
@import "decoration_black.css";
*/
EOS;
	return $importer_css;
}

function get_importer_js($layout) {
	if(substr($layout,0,4)=='2col') {
		$ltype = '2col';
	} elseif(substr($layout,0,4)=='3col') {
		$ltype = '3col';
	} elseif(substr($layout,0,6)=='2_1col') {
		$ltype = '2_1col';
	}
	$importer_js = <<<EOS
	<script type="text/javascript" src="{\$b}/js/jquery-1.2.6.min.js"></script>
	<script type="text/javascript" src="{\$b}/js/jquery.ui-1.0/jquery.dimensions.js"></script>
	<script type="text/javascript" src="{\$b}/js/plugins/jquery.gradient.js"></script>
	<script type="text/javascript" src="{\$b}/js/plugins/ua_curvycorners.js"></script>
	<script type="text/javascript" src="{\$b}/js/layout_$ltype.js"></script>
	<script type="text/javascript" src="{\$b}/js/decoration.js"></script>
EOS;
	return $importer_js;
}

} // end of skin class
?>