<?php
/**
 * Smarty wiki_link modifier plugin
 *
 * Type:     modifier<br>
 * Name:     wiki_link<br>
 * Purpose:  search pukiwiki url link sentense such as "[[name>http://url]]",
 *           change to <a> tag '<a href="http://url" target="_blank">name</a>'.
 * @link http://quicty.zubapita.jp/
 *          mb_truncate (Quicty online manual)
 * @author   Tomoyuki Negishi <tomoyu-n at zubapita dot jp>
 * @param string
 * @return string
 */
function smarty_modifier_wiki_link($string) {
	$string = preg_replace("/\[\[(.+?)>(http:\/\/.+?)\]\]/",'<a href="$2" target="_blank">$1</a>',$string);
	$string = preg_replace("/\[\[(.+?)>(.+?)\]\]/",'<a href="$2">$1</a>',$string);
	return $string;
}

/* vim: set expandtab: */

?>
