<?php
class index_list_options extends myQuicty {

function __construct($page) {
	parent::__construct();
	$this->page = $page;
	$this->list = $this->page->list;
}

var $perPage = 0; // this value set by index_base.list_records

function get_pager_option($add_condition='',$cond='AND') {
	$where_condition = $this->make_where_condition($add_condition,$cond);
	$join_condition = $this->make_join_condition();
	$select_condition = $join_condition.' '.$where_condition;
	$pager_option = $this->set_pager_option($this->perPage,$select_condition);
	return $pager_option;
}

function make_where_condition($add_condition='',$cond='AND') {
	$search_system = array(
		'keyword'=>array('title'=>'restaurant.name',), 
		);
	return $this->list->make_condition($search_system,$add_condition,$cond);
}

function make_join_condition() {
	//$this->list->real_count = true; // set this flag if join other table
	$joins[] = "LEFT JOIN image ON restaurant.id=image.restaurant_id";
	$join_condition = implode(' ',$joins);
	return $join_condition;
}

function make_select_fields() {
	$this->select_system = array(
		'restaurant'=>'*', // specify all column
		'image'=>array('image_caption','image_tag','thumbnail_tag'),
		);
	return $this->list->make_select_fields($this->select_system);
}

function make_grouping_condition() {
	$grouping_condition = 'GROUP BY '.$this->list->make_grouping_fields($this->select_system);
	return $grouping_condition;
}

function make_sort_condition() {
	$sort_system = array(
		'default'=>' order by restaurant.id',
		'columns'=>'*', // specify all column
		);
	if($this->page->sort_option) {
		$this->list->set_sort_option($this->page->sort_option,$this->page->order_option);
	}
	return $this->list->make_order($sort_system);
}

function set_batch_list_option() {
	$this->list->hide_in_batch_list(
		array(
			// write hide field list ex) 'properties','memo'...
		)
	);
	$this->list->freeze_in_batch_list(
		array(
			// write freeze display field list ex) 'name','url'...
		)
	);
}


} // end of class index_list_options
?>