<?php
class image_base extends myQuicty {


function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['data_name'] = 'image';
	return true;
}

function assign_search_form($page_obj=NULL) {
	if($page_obj) {
		$my = $page_obj;
	} else {
		$my = $this;
	}
	$search_form = $my->new_search_obj('image_search',array('action'=>$my->page['base_url'].'/image/','method'=>'get'));
	$my->assign_form('search_form',$search_form);
}

function add_list_options($pager_option) {
	/* this method for override use when included by external class */
	return $pager_option;
}

function list_records($condition='',$perPage=20,$cond='AND') {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('image');
	$options = new image_list_options($this);
	$options->perPage = $perPage;
	$pager_option = $options->get_pager_option($condition,$cond);
	$pager_option = $this->add_list_options($pager_option);
	// Uncomment below 1 line when grouping via select fields.
	//$this->list->count_condition = "GROUP BY image.id";
	$this->list->bind_pager($pager_option);
	
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	// Uncomment below 2 line when grouping via select fields.
	//$group_condition = $options->make_grouping_condition();
	//$sort_condition = $group_condition.' '.$sort_condition;
	$list_table = $this->list->select_table_with_pager($sort_condition,$fields);
	return $list_table;
}

function set_pager() {
	$pager = $this->list->get_pager_links();
	$pager['pages_array'] = explode('&nbsp;&nbsp;',$pager['pages']);
	return $pager;
}

function add_form_options() {
	/* this method for override use when included by external class */
}

function make_subdir($id,$image_dir) {
	umask(0);
	$dir1 = substr(sprintf("%08d",$id),0,2);
	if(!file_exists("$image_dir/$dir1")) mkdir("$image_dir/$dir1",0777);
	$dir2 = substr(sprintf("%08d",$id),2,2);
	if(!file_exists("$image_dir/$dir1/$dir2")) mkdir("$image_dir/$dir1/$dir2",0777);
	$dir3 = substr(sprintf("%08d",$id),4,2);
	if(!file_exists("$image_dir/$dir1/$dir2/$dir3")) mkdir("$image_dir/$dir1/$dir2/$dir3",0777);
	$subdir = "$dir1/$dir2/$dir3";
	return $subdir;
}

function resize_image($image_dir,$ht_img_dir,$file,$basename) {
	$file = $this->form->resize_image($file,64,64,$image_dir,$basename.'_t.'.$file['type'],'thumbnail');
	chmod($file['thumbnail_path'],0666);
	$thumbnail_image = "<img src=\"http://".$_SERVER['SERVER_NAME']."$ht_img_dir/".$file['thumbnail_name']."\" width=\"".$file['thumbnail_width']."\" height=\"".$file['thumbnail_height']."\" border=\"0\" />";

	$file = $this->form->resize_image($file,160,160,$image_dir,$basename.'_n.'.$file['type'],'normal');
	chmod($file['normal_path'],0666);
	$normal_image = "<img src=\"http://".$_SERVER['SERVER_NAME']."$ht_img_dir/".$file['normal_name']."\" width=\"".$file['normal_width']."\" height=\"".$file['normal_height']."\" border=\"0\" />";

	$this->form->update_table(array('image_dir'=>$file['dir'],'image_filename'=>$file['name'],'image_tag'=>$normal_image,'thumbnail_tag'=>$thumbnail_image),"where id=".$this->image['id']);
}

function display_record($condition='') {
	require_once 'form_options.class.php';
	$this->form = $this->new_data_set('image');
	$options = new image_form_options($this);
	$options->set_form_options();
	$this->add_form_options();
	$this->form->validate_and_freeze();
	$this->form->bind_button_control();

	$image_dir = '../var/upload/image';

	if($this->QuictyStatus=='DELETE') {
		$data = $this->form->select("WHERE $condition");
		$subdir = $this->make_subdir($data[0]['id'],$image_dir);
		$ext = substr($data[0]['image_filename'],strpos($data[0]['image_filename'],'.'));
		unlink("$image_dir/$subdir/image".$data[0]['id']."_n$ext");
		unlink("$image_dir/$subdir/image".$data[0]['id']."_t$ext");
	}

	$result = $this->form->automatic_form_handler($condition);
	$this->image = $result['image'] ? $result['image'] : $result['values'];

	if($this->QuictyStatus=='INSERT' or $this->QuictyStatus=='UPDATE') {
		$subdir = $this->make_subdir($this->image['id'],$image_dir);
		$basename = 'image'.$this->image['id'];
		$ht_img_dir = quicty_base_path().'/img/upload/image';
		$file = $this->form->move_upload_file2dir("$image_dir/$subdir",$basename,$element='image_file');
		if($file['result']) {
			$this->resize_image("$image_dir/$subdir","$ht_img_dir/$subdir",$file,$basename);
			unlink("$image_dir/$subdir/".$file['name']);
		}
	}
	return $result;
}


function assign_page_and_pathlist($page_name) {
	$this->set_pathlist('/',$this->W['top']);
	if($this->Quicty['action']!='index') {
		$upper_path = $this->W['image'].$this->W['list'];
		$this->add_pathlist('/image/index.html',$upper_path,false);
	}
	$this->add_pathlist('',$page_name);
	$this->page['name'] = $page_name;
	$this->assign('page',$this->page);
}

function batch_update($condition='') {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('image');
	$options = new image_list_options($this);
	$pager_option = $options->get_pager_option($condition);
	$this->list->bind_pager($pager_option);
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	$options->set_batch_list_option();
	
	$this->list->set_button_status('use_confirm',false);
	$this->list->bind_button_control();
	$list_table = $this->list->automatic_batch_handler($sort_condition,$fields);
	return $list_table;
}



} // end of image_base class
?>