#!/usr/local/php/bin/php
<?php
/**
 *	Project:	Quicty: Quick application build environment for PHP depends on PEAR and Smarty
 *	File:		Quicty/modules/template/userauth/bin/set_user_level.php
 *	Usage:		$ bin/set_user_level.php login_id=foo level=[int|admin_user|registerd_user]
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */
$dir_path = explode('/',dirname(__FILE__));
$dummy = array_pop($dir_path);
$home_dir = implode('/',$dir_path);

require_once $home_dir.'/lib/myQuicty.php';

class set_user_level extends myQuicty {

	function dispatch_index() {
		define('admin_user',10);
		define('registerd_user',1);
		define('guest_user',0);
		$argv = get_argv();
		$login_id =$argv['login_id'];
		$level = $argv['level'];
		echo "set level to $level\n";
		switch($level) {
			case 'admin_user':
				$level = admin_user;
				break;
			case 'registerd_user':
				$level = registerd_user;
				break;
			default:
				if(!is_numeric($level)) {
					die("\n'$level' is not defined user level!\n\n");
				} else {
					$level = (int) $level;
				}
		}
		if($login_id and is_int($level)) {
			$FORM = $this->new_data_set('userauth');
			$condition = "where login_id='$login_id'";
			$update_set = array('level'=>$level);
			$result = $FORM->update_table($update_set,$condition);
			print_r($result);
			if($result['user']['state']) {
				$row = $FORM->select_table($condition);
				print_r($row);
			} else {
				echo "update user level failed..\n";
			}
		}
	}
}
$quicty = new set_user_level($home_dir);
$quicty->dispatch_index();

?>
