package {
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	import flash.ui.*;
	import flash.utils.ByteArray;

	//ダイアログを表示する 
	public class TestMultibyte extends Sprite {
		private var tiEncoding:TextField;
		private var tiSrcText:TextField;
		private var tiEncodedData:TextField;
		private var tiDecoded:TextField;
		private var btnConvert:CustomButton;
		private var jis_converter:JIS4IRC;

		private function mouseUpHandler(ev:MouseEvent):void {
			var ba:ByteArray;
			try{
				// テキストをマルチバイトに変換する
				if( tiEncoding.text == "ISO-2022-JP-IRC" ){
					if( !jis_converter){
						jis_converter = new JIS4IRC();
						jis_converter.setOption("7823c");
					}
					ba = jis_converter.encode(tiSrcText.text);
				}else{
					ba = new ByteArray();
					ba.writeMultiByte(tiSrcText.text,tiEncoding.text);
				}
				var str:String = "";
				for(var i:int =0;i<ba.length;++i){
					var xx:String = (ba[i]+256).toString(16);
					str += xx.substring( xx.length -2)+" ";
				}
				tiEncodedData.text = str;
				try{
					// マルチバイトをテキストに変換する
					ba.position = 0;
					if( tiEncoding.text == "ISO-2022-JP-IRC" ){
						if( !jis_converter){
							jis_converter = new JIS4IRC();
							jis_converter.setOption("7823c");
						}
						tiDecoded.text = jis_converter.decode(ba,ba.length);
					}else{
						tiDecoded.text = ba.readMultiByte(ba.length,tiEncoding.text);
					}
				}catch(e:Error){
					tiDecoded.text = e.message;
					return;
				}
			}catch(e:Error){
				tiEncodedData.text = e.message;
				return;
			}
		}

		public function makeTextField(x:int,y:int,text:String,input:Boolean):TextField{
			var elem:TextField = new TextField();
			elem.x = x;
			elem.y = y;
			elem.text = text;
			if(input){
				elem.type = TextFieldType.INPUT;
				elem.border = true;
				elem.width = 400;
				elem.height = 20;
			}else{
	            elem.autoSize=TextFieldAutoSize.LEFT;
	            elem.selectable=false;
			}
			return elem;
		}

        //コンストラクタ
        public function TestMultibyte(){
			var x:int= 8;
			var y:int= 8;
			var y_step:int = 8;
			var label:TextField;

			label = makeTextField(x,y,"キャラクタセット",false);
            addChild(label);
            tiEncoding = makeTextField(x + label.width +8,y,"ISO-2022-JP-IRC",true);
            addChild(tiEncoding);
            y += label.height +8;

			label = makeTextField(x,y,"対象テキスト",false);
            addChild(label);
            tiSrcText = makeTextField(x + label.width +8,y,"ABC日本語ﾊﾝｶｸ 〜～£¢¬￥\\−…‖ ",true);
            addChild(tiSrcText);
            y += label.height +8;


            // 変換ボタン
            btnConvert = new CustomButton("変換",12);
            btnConvert.addEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
            btnConvert.x = x
            btnConvert.y = y;
            addChild(btnConvert);
            y += btnConvert.height +8;

			label = makeTextField(x,y,"変換したデータ",false);
            addChild(label);
            tiEncodedData = makeTextField(x + label.width +8,y,"",true);
            addChild(tiEncodedData);
            y += label.height +8;

			label = makeTextField(x,y,"デコードしたデータ",false);
            addChild(label);
            tiDecoded = makeTextField(x + label.width +8,y,"",true);
            addChild(tiDecoded);
            y += label.height +8;
		}
    }
}

import flash.display.*;
import flash.filters.*;
import flash.text.*;

//カスタムボタン
class CustomButton extends SimpleButton {

    //コンストラクタ    
    public function CustomButton(label:String="",fontSize:uint=12) {
        //ボタンスプライト
        var downSprite:Sprite=makeButtonSprite( label,fontSize,0x000000,0xdddddd);
        var upSprite  :Sprite=makeButtonSprite( label,fontSize,0xdddddd,0x000000);
        var hitSprite :Sprite=makeButtonSprite( label,fontSize,0x000000,0x000000);

        //状態
        downState   =downSprite;//ダウン
        overState   =upSprite;  //オーバー
        upState     =upSprite;  //アップ

        hitTestState=hitSprite;//当たり判定

        //手アイコンを指定
        useHandCursor=true;
    }
    
    //ボタンスプライトの生成
    private function makeButtonSprite(text:String,fontSize:uint,highlightColor:uint,shadowColor:uint):Sprite {
        //スプライト
        var sp:Sprite=new Sprite();
        //ラベルの指定
        var label:TextField=makeLabel(text,fontSize);
        //描画
        sp.graphics.beginFill(0xdddddd);
        sp.graphics.drawRect(0,0,label.textWidth+6,label.textHeight+6);
        sp.graphics.endFill();
        sp.addChild(label);
        //フィルタの指定
        var filter:BevelFilter=new BevelFilter();
        filter.blurX=2;
        filter.blurY=2;
        filter.distance=1;
        filter.highlightColor=highlightColor;
        filter.shadowColor=shadowColor;
        var myFilters:Array=new Array();
        myFilters.push(filter);
        sp.filters=myFilters; 
        return sp;         
    }

    //ラベルの生成
    private function makeLabel(text:String,fontSize:uint):TextField {
        var i:uint;
        var label:TextField=new TextField();
        label.autoSize=TextFieldAutoSize.LEFT;
        label.selectable=false;
        var format:TextFormat=new TextFormat();
        format.font="_等幅";
        label.text="■";
        for (i=fontSize+10;i>=1;i--) {
            format.size=i;
            label.setTextFormat(format);
            if (label.textWidth<=fontSize) break;
        }
        label.text=text;
        label.setTextFormat(format);
        label.x=3-(label.width -label.textWidth)/2;
        label.y=3-(label.height-label.textHeight)/2; 
        return label;
    } 
}


////////////////////////////////////////////////////////////////////////

// IRC用JISコンバーター
import flash.utils.ByteArray;
class JIS4IRC{
	// 各種変換テーブル

	[Embed(source='x201u2z.map', mimeType='application/octet-stream')]
	private static const map201z_class:Class;
	private var map201z:ByteArray;

	[Embed(source='x208decode.map', mimeType='application/octet-stream')]
	private static const map208decode_class:Class;
	[Embed(source='x212decode.map', mimeType='application/octet-stream')]
	private static const map212decode_class:Class;
	private var map208decode:ByteArray;
	private var map212decode:ByteArray;
	private var map2132decode:ByteArray;

	[Embed(source='x208encode.map', mimeType='application/octet-stream')]
	private static const map208encode_class:Class;
	[Embed(source='x212encode.map', mimeType='application/octet-stream')]
	private static const map212encode_class:Class;
	private var map208encode:ByteArray;
	private var map212encode:ByteArray;

	//
	private function scanTable(table:ByteArray,b1:uint,b2:uint):uint{
		if(table!=null){
			// 上位8ビットのマップを読む
			table.position = b1*2;
			var pos:int = table.readUnsignedShort();
			if(pos != 0xFFFF){
				// 下位8ビットのマップを確認
				table.position=0;
				var size:uint = table[pos++]+1;
				if( b2 >= table[pos] && b2 <= table[pos+size*3-3] ){
					// bsearchする
					while(size>0){
						var mid:uint = size>>1;
						var diff:int = b2-table[pos+mid*3];
						if(!diff) return (table[pos+mid*3+1]<<8)+table[pos+mid*3+2];
						if(diff>0){
							pos += (mid+1)*3;
							size-=  mid+1;
						}else{
							size=mid;
						}
					}
				}
			}
		}
		return 0;
	}
	private function scanDecodeTable(b1:uint,b2:uint,table:ByteArray):String{
		var unicode:uint = scanTable(table,b1,b2);
		if(unicode==0) return "化";
		return String.fromCharCode(unicode);
	}

	private function scanEncodeTable(table:ByteArray,unicode:uint):uint{
		var b1:uint = (unicode>>8)&255;
		var b2:uint = (unicode   )&255;
		var kuten:uint = scanTable(table,b1,b2);
		return kuten;
	}

	// 半角カナのデコード
	private function decodeX201(code:uint,mode:String,shiftmode:int):String{
		code |= 0x80;
		if(code >= 0xa1 && code <= 0xdf ) return String.fromCharCode( code+(0xFF61-0xa1) );
		return "(X201:x"+code.toString(16)+";)";
	}

	private function str2byte(ba:ByteArray,str:String):void{
		for(var i:int=0;i<str.length;++i){
			ba.writeByte(str.charCodeAt(i));
		}
	}

	// JIS X 0201 カタカナの扱い
	private var optX201:int; 
		// 0 z○ 全角カナに変換
		// 1 7○ Kana  7bit "ESC ( I"
		// 2 j○ Roman 8bit "ESC ( J"
		// 3 k○ Roman 7bit "ESC ( J SO/SI"  未対応
	
	// 機種依存文字の扱い
	private var optUseX208extra:Boolean; // 8□ JIS X 0208を120区まで拡張
	private var optUseX212:Boolean;      // 2□ JIS X 0212の使用
	private var optUseX213:Boolean;      // 3□ JIS X 0213の使用

	// エスケープを伴わない非ASCII文字の文字コード
	private var optDefaultEncoding:String;

	// 変換オプションの設定
	public function setOption(str:String):void {
		// デフォルトにリセット
		optX201 = 0;
		optUseX208extra = false;
		optUseX212 = false;
		optUseX213 = false;
		optDefaultEncoding = "ms_Kanji";
	
		for(var i:int = 0;i<str.length;++i){
			var c:String = str.charAt(i);
			switch(c){
			case 'z': optX201 =0; break;
			case '7': optX201 =1; break;
			case 'j': optX201 =2; break;
			case 'k': optX201 =3; break;

			case '8': optUseX208extra =true; break;
			case '2': optUseX212 =true; break;
			case '3': optUseX213 =true; break;

			case 'c': optDefaultEncoding ="ms_Kanji"; break;
			case 'u': optDefaultEncoding ="utf-8"; break;
			case 'a': optDefaultEncoding ="iso-8859-1"; break;
			default:
				trace("JIS4IRC: unknown option character ",c);
			}
		}
	}

	// エンコード時の文字変換
	private var encode_conv_map:Object = {
		'〜':'～',
		'−':'-',
		'∑':'∑',
		'︰':'：',
		'‾':'~'
	};

	// ISO-2022-JP のエスケープシーケンス
	private var esc_map:Object = {};
	private function addEscapeMap( mode:int,str:String):void{
		var ba:ByteArray = new ByteArray();
		str2byte(ba,str);
		esc_map[mode]=ba;
	}

	// コンストラクタ
    public function JIS4IRC(){
		// 埋め込みデータのインスタンスを作成
		map208decode = new map208decode_class();
		map208encode = new map208encode_class();
		map212decode = new map212decode_class();
		map212encode = new map212encode_class();
		map201z      = new map201z_class();

		// esc_mapにエスケープシーケンスを設定
		addEscapeMap( 0,"\x1b(B");
		addEscapeMap( 208  ,"\x1b$\x42");
		addEscapeMap( 212  ,"\x1b$(\x44");
		addEscapeMap( 2131 ,"\x1b$(Q");
		addEscapeMap( 2132 ,"\x1b$(P");
		addEscapeMap( 72010,"\x1b(I");
		addEscapeMap( 82010,"\x1b(J");
	};

	public function decode(ba:ByteArray,length:int):String{
		var result:String = new String();
		var start:int;
		var b:uint;
		Loop: while(ba.bytesAvailable > 0 ){
			// 非エスケープ状態の部分を読む
			{
				start = ba.position;
				var n:int =0;
				// ESCの直前までをまとめて処理する
				while(ba.bytesAvailable > 0 ){
					b = ba.readUnsignedByte();
					if(b== 0x1b) break;
					++n;
				}
				ba.position = start;
				if(n>0){
					for(var i:int=0;i<n;++i){
						result += String.fromCharCode( ba.readUnsignedByte() );
					}
				}
				if(! ba.bytesAvailable ) break;
			}
			start = ba.position;
			var mode:uint = 0;
			// エスケープ部分を読む
			while( ba.bytesAvailable > 0 ){
				b = ba.readUnsignedByte();
				// 空白なら必ずASCIIに戻す
				if(b==0x20) continue Loop;
				// SHIFT OUT
				if(b==0x0e){
					if(mode == 72010){ mode=72011; continue; }
					if(mode == 82010){ mode=82011; continue; }
					continue Loop;
				}
				// SHIFT IN
				if(b==0x0F){
					if(mode===72011){ mode=72010; continue ; }
					if(mode===82011){ mode=82010; continue ; }
					continue  Loop;
				}
				// ESCAPE
				if(b==0x1b){ // ESC
					var elen:int = 1; // エスケープタグの長さ
					if(ba.bytesAvailable >= 2 ){
						elen = 3;
						var c1:uint = ba.readUnsignedByte();
						var c2:uint = ba.readUnsignedByte();
						if(c1 == 0x28 /* ( */ ){
							if(c2 == 0x42 /* B */ ){mode=    0;continue Loop;}	// ASCII ESC (B アスキー
							if(c2 == 0x49 /* I */ ){mode=72010;continue     ;}	// JIS X 0201 片仮名 7ビット半角カナの開始
							if(c2 == 0x4a /* J */ ){mode=82010;continue     ;}	// JIS X0201(LH) ESC (J 半角カナ
						}else if(c1 == 0x24 /* $ */ ){
							if(c2 == 0x40 /* @ */){mode=2131; continue;} // ESC $@ JIS X 0213の1面(include JIS X0208('78)) 
							if(c2 == 0x42 /* B */){mode= 208; continue;} // JIS X0208('83) 
							if(c2 == 0x49 /* I */){mode= 201; continue;} // 8ビット半角カナの開始
							if(c2 == 0x28 /* ( */ && ba.bytesAvailable > 0 ){
								elen = 4;
								var c3:uint = ba.readUnsignedByte();
								if(c3 == 0x4f /* O */){mode=2131; continue;} // JIS X 0213の1面(include JIS X0212?)
								if(c3 == 0x50 /* P */){mode=2132; continue;} // JIS X 0213の2面
								if(c3 == 0x44 /* D */){mode=212;  continue;} // JIS X 0212 補助漢字
							}
						}
					}
					ba.position = ba.position - elen;
					var warnStr:String = "";
					for(var j:int = 0;j<elen;++j){
						b = ba.readUnsignedByte();
						warnStr += " "+ ("00"+b.toString(16)).substr(-2,2);
					}
					result += "(JIS4IRC: unsupported escape sequence"+warnStr+")";
					continue  Loop;
				}
				var b2:uint;
				switch(mode){
				case 0: continue Loop;

				case 201  : result += (decodeX201(b,' ',0)); break;
				case 82010: result += (decodeX201(b,'J',0)); break;
				case 82011: result += (decodeX201(b,'J',1)); break;
				case 72010: result += (decodeX201(b,'I',0)); break;
				case 72011: result += (decodeX201(b,'I',1)); break;

				case 208:
					if(ba.bytesAvailable <1 ) continue Loop;
					b2 = ba.readUnsignedByte();
					result += scanDecodeTable(b,b2,map208decode);
					break;
				case 212:
					if(ba.bytesAvailable <1 ) continue Loop;
					b2 = ba.readUnsignedByte();
					result += scanDecodeTable(b,b2,map212decode);
					break;
				case 2131:
					if(ba.bytesAvailable <1 ) continue Loop;
					b2 = ba.readUnsignedByte();
					result += scanDecodeTable(b,b2,map208decode);
					break;
				case 2132:
					if(ba.bytesAvailable <1 ) continue Loop;
					b2 = ba.readUnsignedByte();
					result += scanDecodeTable(b,b2,map2132decode);
					break;
				default:
					continue Loop;
				}
			}
		}
		return result;
	}


	public function encode(src:String):ByteArray{
		var ba:ByteArray = new ByteArray();
		
		var src_len:int = src.length;
		var mode:int = 0;
		var newmode:int;
		var b1:uint;
		var b2:uint;

		for(var i:int =0;i<src_len;++i){
			var unichar:String = src.charAt(i);
			var tmp:String = encode_conv_map[unichar];
			if( tmp !=null) unichar = tmp;
			var unicode:uint = unichar.charCodeAt(0);

			if( unicode <=0x7f ){
				// ASCIIまたは制御コード
				newmode = 0;
				b1 = unicode;
				b2 = 0;
			}else if( unicode >= 0xFF61 && unicode <= 0xFF9f ){
				// 半角カナ
				unicode -= 0xFF61;
				if( optX201 == 0 ){
					// 全角カナに変換する
					map201z.position = unicode;
					newmode = 208;
					b1 = 0x30;
					b2 = map201z.readUnsignedByte();
				}else{
					b1 = unicode + 0xa1;
					b2 = 0;
					switch(optX201){
					default:
					case 1: newmode=72010; b1 &= 0x7f;break;
					case 2: newmode=82010; break;
					}
				}
			}else{
				do{
					// X208に文字があるか確認する
					var kuten:uint = scanEncodeTable(map208encode,unicode);
					if( kuten >0 ){
						newmode = 208;
						b1 = kuten>>8;
						b2 = kuten&0xff;
						if( optUseX208extra || (b1 <= 126 && b2 <= 126 ) ) break;
					}
				/* 未対応
					if( optUseX213 ){
						kuten = scanEncodeTable(map213encode,unicode);
						if( kuten > 0xFFFF ){
							newmode = 2132;
							b1 = (kuten>>8)&0xff;
							b2 = (kuten   )&0xff;
							break;
						}else if(kuten>0){
							newmode = 2131;
							b1 = (kuten>>8)&0xff;
							b2 = (kuten   )&0xff;
							break;
						}
					}
				*/
					if( optUseX212 ){
						kuten = scanEncodeTable(map212encode,unicode);
						if( kuten >0 ){
							newmode = 212;
							b1 = kuten>>8;
							b2 = kuten&0xff;
							break;
						}
					}
					// 変換できない
					newmode = -1;
				}while(false);
			}
			/////////////
			if( newmode==-1 ){
				if(mode != 0 ){
					mode=0;
					ba.writeBytes(esc_map[mode]);
				}
				str2byte(ba,"&#x"+unicode.toString(16)+";");
			}else{
				if(mode != newmode){
					mode=newmode;
					ba.writeBytes(esc_map[mode]);
				}
				ba.writeByte(b1);
				if(b2!=0) ba.writeByte(b2);
			}
		}
		newmode=0;
		if(mode != newmode) ba.writeBytes(esc_map[mode=newmode]);
		ba.position = 0;
		return ba;
	}

	// references：
	// http://www.asahi-net.or.jp/~wq6k-yn/code/enc-x0213.html
	// http://www2d.biglobe.ne.jp/~msyk/charcode/jisx0201kana/
	// http://www.m17n.org/m17n2000_all_but_registration/proceedings/kawabata/jisx0213.html
	// http://www.ingrid.org/java/i18n/unicode.html
}
