# QuickIP/Admin.pm - QuickIP ̊ǗpG[WFg
#
# Last Change: 28-Jan-2006.
# Written By: Kouichi NANASHIMA <seven@mail7.ph>
package QuickIP::Admin;

use Ipmsg::Agent;
use Ipmsg::HostList;
use QuickIP::Child;

use strict;

use vars qw($VERSION $THISNAME @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA    = qw(Exporter Ipmsg::Agent);
@EXPORT = qw(AdminCmdCreate AdminCmdDrop AdminCmdSep QuickIPGroup);

$VERSION = 0.21;
$THISNAME = "QuickIP AdminAgent module Ver.$VERSION";

# ǗpG[WFgR}h̒萔
# Xg쐬
use constant AdminCmdCreate     => 'Create';
# Xg폜
use constant AdminCmdDrop       => 'Drop';
# R}hXg
use constant AdminCmdList       => '('.AdminCmdCreate.'|'.AdminCmdDrop.')';
# R}hƃIyh̋؂蕶
use constant AdminCmdSep        => ':';
# R}hpK\
my $AdminCmdRegexp = '^\s*'.AdminCmdList.'('.AdminCmdSep.'([^'.AdminCmdSep.']+))$';

# ǗpG[WFg̃[U
use constant AdminUser          => 'QuickIPAdmin';
# ǗpG[WFg̃jbNl[
use constant AdminNickName      => 'QuickIPǗp[U';
# QuickIPG[WFg̃O[v
use constant QuickIPGroup       => 'QuickIP';

# bZ[W̒萔
# s؂L
use constant Linesep            => "\n";
# Xg쐬bZ[W
use constant MsgCreate          => 'ɂăbZ[WOXg쐬܂B'.Linesep;
# Xg폜bZ[W
use constant MsgDrop            => 'ɂăbZ[WOXg폜܂B'.Linesep;
# [UbZ[WƃVXebZ[W̋؂蕶
use constant UserSystemSep      => '--'.Linesep;
# G[bZ[W̐ړ
use constant MsgErrPrefix       => '';
# bZ[WMs̃G[bZ[W
use constant MsgErrCannotSend   => 'ɂ͑Mł܂łB'.Linesep;

# ǗpG[WFg̒OC
use constant AdminLoginInterval => 300;
# ǗpG[WFg̃zXgXgW҂
use constant AdminWaitTime      => 5;

# vpeBANZXp萔
# qG[WFgXg
use constant ChildList          => 17;
# zMbZ[WXg
use constant MessageList        => 18;
# gp\|[gXg
use constant EnablePortList     => 19;
# ŏIOC
use constant LastEntry          => 20;
# G[WFgtO
use constant AliveFlg           => 21;
# Mς݃bZ[WL[
use constant RecvMsgQueue       => 22;

sub new {
  my $pkg = shift;
  my %options = @_;
  my $minPort = $options{MinPort};
  my $maxPort = $options{MaxPort};

  %options->{User}      = AdminUser if (!%options->{User});
  %options->{NickName}  = AdminNickName if (!%options->{NickName});
  %options->{Group}     = QuickIPGroup if (!%options->{Group});
  my $self = Ipmsg::Agent->new(%options);

  # gp\|[gXg̏
  if (!$minPort || !$maxPort || $minPort > $maxPort) {
    return undef;
  }
  my $enablePortList = [];
  for (my $i = $maxPort; $i >= $minPort; $i--) {
    push(@$enablePortList, $i);
  }

  # IuWFNg
  $self->[ChildList] = [];
  $self->[MessageList] = [];
  $self->[EnablePortList] = $enablePortList;
  $self->[LastEntry] = 0;
  $self->[AliveFlg] = 1;
  $self->[RecvMsgQueue] = [];

  return bless $self, $pkg;
}

# qG[WFgXg擾
sub childlist {
  my $self = shift;

  return $self->[ChildList];
}

# zMbZ[WXg擾
sub messagelist {
  my $self = shift;

  return $self->[MessageList];
}

# gp\|[gXgK
sub enableportlist {
  my $self = shift;

  return $self->[EnablePortList];
}

# ŏIOC擾
sub lastentry {
  my $self = shift;

  return $self->[LastEntry];
}

# G[WFgǂ𔻒肷
sub isAlive {
  my $self = shift;

  return ($self->[AliveFlg] == 1);
}

# Mς݃bZ[WL[擾
sub recvmsgqueue {
  my $self = shift;

  return $self->[RecvMsgQueue];
}

# ǗpG[WFgzXgXgW҂ǂ𔻒肷
sub isWait {
  my $self = shift;
  my $time = time;
  my $lastentry = $self->lastentry;

  return (($time - $lastentry) < AdminWaitTime);
}

# qG[WFgXgɒǉ
sub AddChild {
  my $self = shift;
  my $child = shift;

  push @{$self->[ChildList]}, $child;
}

# qG[WFgXg擾
sub GetChild {
  my $self = shift;
  my $name = shift;
  my $childlist = $self->childlist;
  my @retval = ();

  foreach my $child (@$childlist) {
    my $childhost = $child->hostinfo;
    if ($childhost->user eq $name || $childhost->nickname eq $name) {
      push @retval, $child;
    }
  }

  return @retval;
}

# qG[WFg폜
sub RemoveChild {
  my $self = shift;
  my $child = shift;
  my $childlist = $self->childlist;

  for (my $i = 0; $i <= $#$childlist; $i++) {
    if (@$childlist[$i] eq $child) {
      splice (@$childlist, $i, 1);
      last;
    }
  }
}

# gp\|[gXg|[gԍ擾
sub ReservePort {
  my $self = shift;
  my $enablePortList = $self->enableportlist;

  my $port = pop(@$enablePortList);
  return $port;
}

# |[gԍĎgp\|[gXgɒǉ
sub ReleasePort {
  my $self = shift;
  my $port = shift;
  my $enablePortList = $self->enableportlist;

  push (@$enablePortList, $port);
}

# OC
sub Login {
  my $self = shift;

  my $time = time;
  my $lastentry = $self->lastentry;

  # ŏIOCAdminLoginIntervalo߂Ă΍ăOC
  if (($time - $lastentry) >= AdminLoginInterval) {
    $self->hostlist->flush;
    $self->SUPER::Login;
    foreach my $child (@{$self->childlist}) {
      $child->Login;
    }
    $self->[LastEntry] = $time;
  }
}

# OAEg
sub Logout {
  my $self = shift;

  $self->SUPER::Logout;
  for my $if ( $self->netif ){
    while( $if->remainqueue ){ $if->send_queue; }
  }
}

# bZ[WM
sub recv {
  my $self = shift;
  my %options = @_;
  my $recvmsgqueue = $self->recvmsgqueue;

  # \Pbg̃bZ[WSĎMăL[Ɋi[
  while (my $recv = $self->SUPER::recv(%options)) {
    # Mς݂̃bZ[W̓L[Ɋi[Ȃ
    my $isRecv = 0;
    for (my $i = 0; $i <= $#$recvmsgqueue; $i++) {
      my $msg = @$recvmsgqueue[$i];
      if ($msg->packetn eq $recv->packetn and
          $msg->addr eq $recv->addr and
          $msg->port eq $recv->port) {
        $isRecv = 1;
        last;
      }
    }
    push @$recvmsgqueue, $recv if (!$isRecv);
  }

  my $retval = undef;
  if ($#$recvmsgqueue >= 0) {
    $retval = @$recvmsgqueue[0];
    splice @$recvmsgqueue, 0, 1;
  }
  return $retval;
}

# [v
sub MainLoop {
  my $self = shift;

  while ($self->isAlive) {
    $self->Login;
    for my $if ($self->netif) {
      my $recv = $self->recv(NetIF => $if, FROMCHECK => 1);
      $self->ForwardMessage();
      $self->send_queue(NetIF => $if);

      next if !$recv;
      $self->MsgProcess($recv);
    }
    foreach my $child (@{$self->childlist}) {
      if ($child->isAlive) {
        for my $if ($child->netif) {
          my $recv = $child->recv(NetIF => $if, FROMCHECK => 1);
          $child->ForwardMessage();
          $child->send_queue(NetIF => $if);

          next if !$recv;
          $child->MsgProcess($recv);
        }
      } else {
        $self->ReleasePort($child->hostinfo->port);
        $self->RemoveChild($child);
        $child->Logout;
        $child = undef;
      }
    }
  }
  $self->Logout;
}

# bZ[W]
sub ForwardMessage {
  my $self = shift;

  # ǗpG[WFgzXgXgW̏ꍇ̓bZ[WMȂ
  my $time = time;
  my $lastEntry = $self->lastentry;
  if ($self->isWait) {
    return;
  }

  my ($msg, $auto, $recv, $forwardlist) = $self->RemoveMessage();
  if ($msg eq undef) {
    return;
  }
  my @hostlist = ();
  foreach my $forward (@$forwardlist) {
    my @hostpartlist = $self->SearchHost($forward);
    if ($#hostpartlist >= 0) {
      foreach my $host (@hostpartlist) {
        push @hostlist, $host;
      }
    } else {
      $auto = $auto.MsgErrPrefix.$forward.MsgErrCannotSend;
    }
  }
  my $ext = $msg;
  $ext = $ext.UserSystemSep.$auto if $auto ne '';

  foreach my $host (@hostlist) {
    my $send = $self->message(
      PeerAddr  => $host->addr,
      PeerPort  => $host->port,
      User      => $recv->user,
      Ext       => $ext);
    $send->sendmsg->sendcheckopt->queue;
  }
}

# bZ[WR}h
sub MsgProcess {
  my $self = shift;
  my $recv = shift;

  my $retval = 1;
  my $msg = '';
  my $auto = '';
  my @forwardList = ();
  if ($recv and $recv->sendmsg) {
    my $ext = $recv->ext;
    my $linesep = Linesep;
    my @lines = split(/$linesep/, $recv->ext);
    foreach my $line (@lines) {
      # R}hsǂ𔻒
      if ($line =~ /$AdminCmdRegexp/) {
        # R}hƈ擾
        my $operation = $1;
        my $operand = $3;
        if ($operation eq AdminCmdCreate) {
          # R}hXg쐬̏ꍇ
          $self->AddMessage($msg, $auto, $recv, \@forwardList);
          @forwardList = ();
          $msg = '';
          $auto = '';

          my @result = $self->CreateProcess($operation, $operand, $recv);
          $msg = $msg.shift(@result);
          $auto = $auto.shift(@result);
          foreach my $forward (@{shift(@result)}) {
            push @forwardList, $forward;
          }
        } elsif ($operation eq AdminCmdDrop) {
          # R}hXg폜̏ꍇ
          $self->AddMessage($msg, $auto, $recv, \@forwardList);
          @forwardList = ();
          $msg = '';
          $auto = '';

          my @result = $self->DropProcess($operation, $operand, $recv);
          $msg = $msg.shift(@result);
          $auto = $auto.shift(@result);
          foreach my $forward (@{shift(@result)}) {
            push @forwardList, $forward;
          }
        }
      } else {
        $msg = $msg.$line.Linesep;
      }
    }

    $self->AddMessage($msg, $auto, $recv, \@forwardList);
    @forwardList = ();
    $msg = '';
    $auto = '';
  }

  return $retval;
}

# Xg쐬
sub CreateProcess {
  my $self = shift;
  my $operation = shift;
  my $operand = shift;
  my $recv = shift;

  my $msg = '';
  my $auto = '';
  my @forward = ();
  # 󂫃|[g̎擾
  my $childport = $self->ReservePort;
  if ($childport) {
    my @broadcasts = $self->get_broadcast;
    my $child = QuickIP::Child->new(
      LocalAddr => $self->hostinfo->addr,
      LocalPort => $childport,
      User      => ChildUserPrefix.$childport,
      Group     => QuickIPGroup,
      NickName  => $operand,
      Admin     => $self);
    for (my $i = 0; $i < $#broadcasts; $i += 3) {
      $child->add_broadcast(
        PeerNet   => @broadcasts[$i + 0],
        PeerPort  => @broadcasts[$i + 1],
        NetMask   => '255.255.255.255');
    }
    $self->AddChild($child);
    $child->Login;
    $msg = $msg.ChildCmdAdd.ChildCmdSep.$recv->user.Linesep;
    $auto = $auto.$recv->user.MsgCreate;
    push @forward, $child->hostinfo->user;
  }

  return ($msg, $auto, \@forward);
}

# Xg폜
sub DropProcess {
  my $self = shift;
  my $operation = shift;
  my $operand = shift;
  my $recv = shift;

  my $msg = '';
  my $auto = '';
  my @forward = ();

  $msg = $msg.ChildCmdQuit.ChildCmdSep.$recv->user.Linesep;
  $auto = $auto.$recv->user.MsgDrop;
  push @forward, $operand;

  return ($msg, $auto, \@forward);
}

# zXg
sub SearchHost {
  my $self = shift;
  my $name = shift;
  my $hostlist = $self->hostlist;
  my @retval = ();

  foreach my $host ($hostlist->get) {
    if ($host->user eq $name || $host->nickname eq $name) {
      push @retval, $host;
    }
  }
  foreach my $child ($self->GetChild($name)) {
    push @retval, $child->hostinfo;
  }

  return @retval;
}

# zMbZ[Wǉ
sub AddMessage {
  my $self = shift;
  my $msg = shift;
  my $auto = shift;
  my $recv = shift;
  my $memberlist = shift;
  my $messagelist = $self->messagelist;

  if ($#$memberlist < 0) {
    return;
  }
  my @memberlist2 = ();
  foreach my $member (@$memberlist) {
    push @memberlist2, $member;
  }
  my $content = [$msg, $auto, $recv, \@memberlist2];
  push @$messagelist, $content;
}

# zMbZ[W폜
sub RemoveMessage {
  my $self = shift;
  my $messagelist = $self->messagelist;

  if ($#$messagelist < 0) {
    return (undef, undef, undef, undef);
  } else {
    return @{pop @$messagelist};
  }
}

1;
