#
# $Id: Send.pm,v 0.06 2003/09/20 Mikio Fukushima Exp Mikio Fukushima $
#

package Ipmsg::Message::Send;
use Ipmsg::Common;
use Ipmsg::Message;

use IO::Socket;

use strict;

use vars qw( $VERSION $THISNAME
	@ISA @EXPORT @EXPORT_OK
);

require Exporter;
require AutoLoader;

@ISA	= qw( Exporter AutoLoader Ipmsg::Message Ipmsg::Common );
@EXPORT	= qw();

# --------------------
# Set global variables in this module.
#

	$VERSION	= 0.06;
	$THISNAME	= "Ipmsg Send Message module Ver.$VERSION";

	use constant Code	=> 0;

	my %_index = (
		Code => Code,
	);

# --------------------
# Category: Constructor

# --------------------
# Name: new

sub new
{
	my ( $class, %arg ) = @_;

	my $self = $class->SUPER::new( %arg );

	#	print $self->SUPER::display;
	#	print $self->SUPER::_index( 'PeerAddr' ),"\n";

	return $self;
}

# --------------------
# Category: Access methods

# --------------------
# Name: setting message command

# --------------------
# Sub1: nooperation

sub nooperation
{
	my ( $self ) = shift;

	# --------------------
	# set command and ext

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_NOOPERATION' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub1: entry

# --------------------
# Sub2: entry
#
# 0x1, 1

sub entry
{
	my ( $self ) = shift;

	# --------------------
	# set command and ext

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_BR_ENTRY' ) );

	$self->ext( $self->nickname ) if $self->nickname;
	$self->ext( $self->nickname . $self->delim_group . $self->group ) if $self->group;

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: exit
#
# 0x2, 2

sub exit
{
	my ( $self ) = shift;

	# --------------------
	# set command and ext

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_BR_EXIT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: ansentry
#
# 0x3, 3

sub ansentry
{
	my ( $self ) = shift;

	# --------------------
	# set command and ext

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_ANSENTRY' ) );

	$self->ext( $self->nickname ) if $self->nickname;
	$self->ext( $self->nickname . $self->delim_group . $self->group ) if $self->group;

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: absence
#
# 0x4, 4

sub absence
{
	my ( $self ) = shift;

	# --------------------
	# set command and ext

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_BR_ABSENCE' ) + $self->ipmsg_cmd( 'IPMSG_ABSENCEOPT' ) );

	$self->ext( $self->nickname ) if $self->nickname;
	$self->ext( $self->nickname . $self->delim_group . $self->group ) if $self->group;

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub1: list

# --------------------
# Sub2: isgetlist
#
# 0x10, 16

sub isgetlist
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_BR_ISGETLIST

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_BR_ISGETLIST' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: okgetlist
#
# 0x11, 17

sub okgetlist
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_OKGETLIST

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_OKGETLIST' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: getlist
#
# 0x12, 18

sub getlist
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_GETLIST

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_GETLIST' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: anslist
#
# 0x13, 19

sub anslist
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_ANSLIST

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_ANSLIST' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: isgetlist2
#
# 0x18, 24

sub isgetlist2
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_BR_ISGETLIST2

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_BR_ISGETLIST2' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub1: message

# --------------------
# Sub2: sendmsg
#
# 0x20, 32

sub sendmsg
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_SENDMSG

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_SENDMSG' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: recvmsg
#
# 0x21, 33

sub recvmsg
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_RECVMSG

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_RECVMSG' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: readmsg
#
# 0x30, 48

sub readmsg
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_RECVMSG

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_READMSG' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: delmsg
#
# 0x31, 49

sub delmsg
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_DELMSG

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_DELMSG' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: ansreadmsg
#
# 0x32, 50

sub ansreadmsg
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_RECVMSG

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_ANSREADMSG' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub1: info

# --------------------
# Sub2: getinfo
#
# 0x40, 64

sub getinfo
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_GETINFO

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_GETINFO' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: sendinfo
#
# 0x41, 65

sub sendinfo
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_SENDINFO

	$self->command(
		$self->command +
		$self->ipmsg_cmd( 'IPMSG_SENDINFO' ) +
		$self->ipmsg_cmd( 'IPMSG_AUTORETOPT' )
	);

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: getabsenceinfo
#
# 0x50, 80

sub getabsenceinfo
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_GETABSENCEINFO

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_GETABSENCEINFO' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: sendabsenceinfo
#
# 0x51, 81

sub sendabsenceinfo
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_SENDABSENCEINFO

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_SENDABSENCEINFO' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub1: key

# --------------------
# Sub2: getpubkey
#
# 0x72, 114

sub getpubkey
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_GETPUBKEY

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_GETPUBKEY' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: anspubkey
#
# 0x73, 115

sub anspubkey
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_ANSPUBKEY

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_ANSPUBKEY' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Name: setting message options

# --------------------
# Sub1: options for all command

# --------------------
# Sub2: absenceopt
#
# 0x100, 256

sub absenceopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_ABSENCEOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_ABSENCEOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: serveropt
#
# 0x200, 512

sub serveropt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_SERVEROPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_SERVEROPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: dialupopt
#
# 0x10000, 65536

sub dialupopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_DIALUPOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_DIALUPOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: fileattachopt
#
# 0x200000, 2097152

sub fileattachopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_FILEATTACHOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_FILEATTACHOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: encryptopt
#
# 0x400000, 4194304

sub encryptopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_ENCRYPTOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_ENCRYPTOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub1: options for send command

# --------------------
# Sub2: sendcheckopt
#
# 0x100, 256

sub sendcheckopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_SENDCHECKOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_SENDCHECKOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: secretopt
#
# 0x200, 512

sub secretopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_SECRETOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_SECRETOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: broadcastopt
#
# 0x400, 1024

sub broadcastopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_BROADCASTOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_BROADCASTOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: multicastopt
#
# 0x800, 2048

sub multicastopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_MULTICASTOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_MULTICASTOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: autoretopt
#
# 0x2000, 8192

sub autoretopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_AUTORETOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_AUTORETOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: retryopt
#
# 0x4000, 16384

sub retryopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_RETRYOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_RETRYOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: passwordopt
#
# 0x8000, 32768

sub passwordopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_PASSWORDOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_PASSWORDOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: nologopt
#
# 0x20000, 131072

sub nologopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_NOLOGOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_NOLOGOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: newmultiopt
#
# 0x40000, 262144

sub newmultiopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_MULTICASTOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_MULTICASTOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: noaddlistopt
#
# 0x80000, 524288

sub noaddlistopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_NOADDLISTOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_NOADDLISTOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: readcheckopt
#
# 0x10000, 1048576

sub readcheckopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_READCHECKOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_READCHECKOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Sub2: secretexopt
#

sub secretexopt
{
	my ( $self ) = shift;

	# --------------------
	# IPMSG_SECRETEXOPT

	$self->command( $self->command + $self->ipmsg_cmd( 'IPMSG_SECRETEXOPT' ) );

	# --------------------
	# return

	return $self;
}

# --------------------
# Category: Methods

# --------------------
# Name: send
#
# message format : 1:100:shirouzu:jupiter:32:Hello

sub send
{
	my $self = shift;

	# --------------------
	# initialize

	my $sockaddr = sockaddr_in( $self->port, inet_aton( $self->addr ) );

	# --------------------
	# send

	return send $self->netif->socket, substr( $self->as_message, 0, $self->udpbuf ), 0, $sockaddr;
}

# --------------------
# Name: queue

sub queue
{
	my ( $self, %options ) = @_;

	# --------------------
	# check requirements

	if( ! $options{ Mode } ){ $options{ Mode } = 'queue'; }

	# --------------------
	# push Send Message to SendQueue

	$self->netif->queue( $self, Mode => $options{ Mode } );

	# --------------------
	# return

	return $self;
}

# --------------------
# Name: verbose
#
# message format : 1:100:shirouzu:jupiter:32:Hello

sub verbose
{
	my ( $self ) = shift;

	# --------------------
	# print

	printf STDOUT "send : %s\n", scalar localtime( time );
	printf STDOUT "       %s:%s => %s:%s : %s : %s : %s bytes\n",
		$self->netif->addr, $self->netif->port,
		$self->addr, $self->port,
		$self->get_mode( $self->command ), $self->get_opt( $self->command ),
		$self->length;
	printf STDOUT "       %s\n", $self->as_string( $self->as_message );

}

# --------------------
# Category: Setting object

1;

