#
# $Id: Recv.pm,v 0.06 2003/09/20 Mikio Fukushima Exp Mikio Fukushima $
#

package Ipmsg::Message::Recv;
use Ipmsg::Common;
use Ipmsg::Message;

use strict;

use vars qw( $VERSION $THISNAME
	@ISA @EXPORT @EXPORT_OK
);

require Exporter;
require AutoLoader;

@ISA	= qw( Exporter AutoLoader Ipmsg::Message Ipmsg::Common );
@EXPORT	= qw();

# --------------------
# Set global variables in this module.
#

	$VERSION	= 0.05;
	$THISNAME	= "Ipmsg Received Message module Ver.$VERSION";

	use constant Code	=> 0;

	my %_index = (
		Code => Code,
	);

# --------------------
# Category: Constructor

# --------------------
# Name: new

sub new
{
	my ( $class, %arg ) = @_;

	my $self = $class->SUPER::new( %arg );

	#	print $self->SUPER::display;
	#	print $self->SUPER::_index( 'PeerAddr' ),"\n";

	return $self;
}

# --------------------
# Category: Access methods

# --------------------
# Name: setting message

# --------------------
# Sub1: nooperation

sub nooperation
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_NOOPERATION

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_NOOPERATION' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub1: entry

# --------------------
# Sub2: entry
#
# 0x1, 1

sub entry
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_BR_ENTRY

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_BR_ENTRY' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: exit
#
# 0x2, 2

sub exit
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_BR_EXIT

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_BR_EXIT' );

	# --------------------
	# return

	return 0;
}

# --------------------
# Sub2: ansentry
#
# 0x3, 3

sub ansentry
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_ANSENTRY

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_ANSENTRY' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: absence
#
# 0x4, 4

sub absence
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_BR_ABSENCE

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_BR_ABSENCE' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub1: hostlist

# --------------------
# Sub2: isgetlist
#
# 0x10, 16

sub isgetlist
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_BR_ISGETLIST

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_BR_ISGETLIST' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: okgetlist
#
# 0x11, 17

sub okgetlist
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_OKGETLIST

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_OKGETLIST' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: getlist
#
# 0x12, 18

sub getlist
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_GETLIST

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_GETLIST' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: anslist
#
# 0x13, 19

sub anslist
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_ANSLIST

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_ANSLIST' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: isgetlist2
#
# 0x18, 24

sub isgetlist2
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_BR_ISGETLIST2

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_BR_ISGETLIST2' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub1: message

# --------------------
# Sub2: sendmsg
#
# 0x20, 32

sub sendmsg
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_SENDMSG

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_SENDMSG' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: recvmsg
#
# 0x21, 33

sub recvmsg
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_RECVMSG

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_RECVMSG' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: readmsg
#
# 0x30, 48

sub readmsg
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_READMSG

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_READMSG' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: delmsg
#
# 0x31, 49

sub delmsg
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_DELMSG

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_DELMSG' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: ansreadmsg
#
# 0x32, 50

sub ansreadmsg
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_ANSREADMSG

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_ANSREADMSG' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub1: info

# --------------------
# Sub2: getinfo
#
# 0x40, 64

sub getinfo
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_GETINFO

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_GETINFO' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: sendinfo
#
# 0x41, 65

sub sendinfo
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_SENDINFO

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_SENDINFO' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: getabsenceinfo
#
# 0x50, 80

sub getabsenceinfo
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_GETABSENCEINFO

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_GETABSENCEINFO' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: sendabsenceinfo
#
# 0x51, 81

sub sendabsenceinfo
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_SENDABSENCEINFO

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_SENDABSENCEINFO' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub1: key

# --------------------
# Sub2: getpubkey
#
# 0x72, 114

sub getpubkey
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_GETPUBKEY

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_GETPUBKEY' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: anspubkey
#
# 0x73, 115

sub anspubkey
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_ANSPUBKEY

	return 1 if $self->mode == $self->ipmsg_cmd( 'IPMSG_ANSPUBKEY' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Name: setting message options

# --------------------
# Sub1: options for all command

# --------------------
# Sub2: absenceopt
#
# 0x100, 256

sub absenceopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_ABSENCEOPT

	return 1 if $self->get_opt( $self->command ) & $self->ipmsg_cmd( 'IPMSG_ABSENCEOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: serveropt
#
# 0x200, 512

sub serveropt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_SERVEROPT

	return 1 if $self->get_opt( $self->command ) & $self->ipmsg_cmd( 'IPMSG_SERVEROPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: dialupopt
#
# 0x10000, 65536

sub dialupopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_SERVEROPT

	return 1 if $self->get_opt( $self->command ) & $self->ipmsg_cmd( 'IPMSG_DIALUPOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: fileattachopt
#
# 0x200000, 2097152

sub fileattachopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_FILEATTACHOPT

	return 1 if $self->get_opt( $self->command ) & $self->ipmsg_cmd( 'IPMSG_FILEATTACHOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: encryptopt
#
# 0x400000, 4194304

sub encryptopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_ENCRYPTOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_ENCRYPTOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub1: options for send command

# --------------------
# Sub2: sendcheckopt
#
# 0x100, 256

sub sendcheckopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_SENDCHECKOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_SENDCHECKOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: secretopt
#
# 0x200, 512

sub secretopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_SECRETOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_SECRETOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: broadcastopt
#
# 0x400, 1024

sub broadcastopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_BROADCASTOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_BROADCASTOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: multicastopt
#
# 0x800, 2048

sub multicastopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_MULTICASTOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_MULTICASTOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: autoretopt
#
# 0x2000, 8192

sub autoretopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_AUTORETOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_AUTORETOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: retryopt
#
# 0x4000, 16384

sub retryopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_RETRYOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_RETRYOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: passwordopt
#
# 0x8000, 32768

sub passwordopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_PASSWORDOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_PASSWORDOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: nologopt
#
# 0x20000, 131072

sub nologopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_NOLOGOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_NOLOGOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: newmultiopt
#
# 0x40000, 262144

sub newmultiopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_NEWMUTIOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_NEWMUTIOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: noaddlistopt
#
# 0x80000, 524288

sub noaddlistopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_NOADDLISTOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_NOADDLISTOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: readcheckopt
#
# 0x10000, 1048576

sub readcheckopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_READCHECKOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_READCHECKOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Sub2: secretexopt
#

sub secretexopt
{
	my ( $self ) = shift;

	# --------------------
	# if IPMSG_SECRETEXOPT

	return 1 if $self->opt & $self->ipmsg_cmd( 'IPMSG_SECRETEXOPT' );

	# --------------------
	# other command

	return 0;
}

# --------------------
# Category: Methods

# --------------------
# Name: reply

sub reply
{
	my ( $self ) = @_;

	# --------------------
	# return

	return $self->netif->reply( $self );
}

# --------------------
# Name: verbose
#
# message format : 1:100:shirouzu:jupiter:32:Hello

sub verbose
{
	my ( $self ) = shift;

	# --------------------
	# print

	printf STDOUT "recv : %s\n", scalar localtime( time );
	printf STDOUT "       %s:%s => %s:%s : %s : %s : %s bytes\n",
		$self->addr, $self->port,
		$self->netif->addr, $self->netif->port,
		$self->get_mode( $self->command ), $self->get_opt( $self->command ),
		$self->length;
	printf STDOUT "       %s\n", $self->as_string( $self->as_message );

}

# --------------------
# Category: Setting object

1;

