#
# $Id: Ipmsg::Common.pm,v 0.05 2003/09/18 Mikio Fukushima Exp Mikio Fukushima $
#

package Ipmsg::Common;

use strict;

use vars qw( $VERSION $THISNAME

	$PROTO_VER

	$DELIM_STRING $DELIM_GROUP $DELIM_HOSTLIST $DELIM_DUMMY
	$TIMEOUT_RECV $DEFAULT_PORT $MAX_SOCKBUF $MAX_UDPBUF $MAX_NAMEBUF
	%ipmsg_cmd %ipmsg_opt

	@ISA @EXPORT @EXPORT_OK
);

require Exporter;
require AutoLoader;

@ISA	= qw( Exporter AutoLoader );
@EXPORT	= qw();

# --------------------
# Set global variables in this module.
#

	$VERSION	= 0.05;
	$THISNAME	= "module Ver.$VERSION";

	$PROTO_VER		= 1;

	$DELIM_STRING	= ":";
	$DELIM_GROUP	= "\0";
	$DELIM_HOSTLIST	= "\a";
	$DELIM_DUMMY    = "\b";

	$TIMEOUT_RECV	= 0.01;

	$DEFAULT_PORT	= 2425;

	$MAX_SOCKBUF	= 65535;
	$MAX_UDPBUF		= 8192;
	$MAX_NAMEBUF	= 50; 

	use constant code	=> 0;

	my %_index = (
		code => code,
	);

# --------------------
# Category: Constructor

# --------------------
# Name: new

sub new
{
	my $class = shift;
	   $class = ref( $class ) || $class;

	my %arg = @_;
	my $self = [];

	# --------------------
	# initialize

	@{ $self }[ values %_index ] = @arg{ keys %_index };

	# --------------------
	# set default

	$self->[ code ]			= 1;

	# --------------------
	# bless

	bless $self, $class;

	# --------------------
	# command init

	return $self;
}

# --------------------
# Category: Access methods

# --------------------
# Name: proto_ver

sub proto_ver
{
	return( $PROTO_VER );
}

# --------------------
# Name: delim_dummy

sub delim_dummy
{
	return( $DELIM_DUMMY );
}

# --------------------
# Name: delim_hostlist

sub delim_hostlist
{
	return( $DELIM_HOSTLIST );
}

# --------------------
# Name: delim_string

sub delim_string
{
	return( $DELIM_STRING );
}

# --------------------
# Name: delim_group

sub delim_group
{
	return( $DELIM_GROUP );
}

# --------------------
# Name: timeout_recv

sub timeout_recv
{
	return( $TIMEOUT_RECV );
}

# --------------------
# Name: default_port

sub default_port
{
	return( $DEFAULT_PORT );
}

# --------------------
# Name: sockbuf

sub sockbuf
{
	return( $MAX_SOCKBUF );
}

# --------------------
# Sub1: udpbuf

sub udpbuf
{
	return( $MAX_UDPBUF );
}

# --------------------
# Name: namebuf

sub namebuf
{
	return( $MAX_NAMEBUF );
}

# --------------------
# Name: ipmsg_cmd

sub ipmsg_cmd
{
	my ( $self, $command ) = @_;

	# --------------------
	# return

	return $ipmsg_cmd{ $command } if $command;
	return keys %ipmsg_cmd;
}

# --------------------
# Name: %ipmsg_cmd

%ipmsg_cmd = (

	#/*  command */
	IPMSG_NOOPERATION		=>	0x00000000,	#0

	IPMSG_BR_ENTRY			=>	0x00000001,	#1
	IPMSG_BR_EXIT			=>	0x00000002,	#2
	IPMSG_ANSENTRY			=>	0x00000003,	#3
	IPMSG_BR_ABSENCE		=>	0x00000004,	#4

	IPMSG_BR_ISGETLIST		=>	0x00000010,	#16
	IPMSG_OKGETLIST			=>	0x00000011,	#17
	IPMSG_GETLIST			=>	0x00000012,	#18
	IPMSG_ANSLIST			=>	0x00000013,	#19
	IPMSG_BR_ISGETLIST2		=>	0x00000018,	#24

	IPMSG_SENDMSG			=>	0x00000020,	#32
	IPMSG_RECVMSG			=>	0x00000021,	#33
	IPMSG_READMSG			=>	0x00000030,	#48
	IPMSG_DELMSG			=>	0x00000031,	#49
	IPMSG_ANSREADMSG		=>	0x00000032,	#50

	IPMSG_GETINFO			=>	0x00000040,	#64
	IPMSG_SENDINFO			=>	0x00000041,	#65

	IPMSG_GETABSENCEINFO	=>	0x00000050,	#80
	IPMSG_SENDABSENCEINFO	=>	0x00000051,	#81

	IPMSG_GETFILEDATA		=>	0x00000060,	#96
	IPMSG_RELEASEFILES		=>	0x00000061,	#97
	IPMSG_GETDIRFILES		=>	0x00000062, #98

	IPMSG_GETPUBKEY			=>	0x00000072,	#114
	IPMSG_ANSPUBKEY			=>	0x00000073,	#115

	#/*  option for all command  */
	IPMSG_ABSENCEOPT		=>	0x00000100,	#256
	IPMSG_SERVEROPT			=>	0x00000200,	#512
	IPMSG_DIALUPOPT			=>	0x00010000,	#65536
	IPMSG_FILEATTACHOPT		=>	0x00200000,	#2097152
	IPMSG_ENCRYPTOPT		=>	0x00400000,	#4194304

	#/*  option for send command  */
	IPMSG_SENDCHECKOPT		=>	0x00000100,	#256
	IPMSG_SECRETOPT			=>	0x00000200,	#512
	IPMSG_BROADCASTOPT		=>	0x00000400,	#1024
	IPMSG_MULTICASTOPT		=>	0x00000800,	#2048
	IPMSG_NOPOPUPOPT		=>	0x00001000,	#4096
	IPMSG_AUTORETOPT		=>	0x00002000,	#8192
	IPMSG_RETRYOPT			=>	0x00004000,	#16384
	IPMSG_PASSWORDOPT		=>	0x00008000,	#32768
	IPMSG_NOLOGOPT			=>	0x00020000,	#131072
	IPMSG_NEWMUTIOPT		=>	0x00040000,	#262144
	IPMSG_NOADDLISTOPT		=>	0x00080000,	#524288
	IPMSG_READCHECKOPT		=>	0x00100000,	#1048576
	IPMSG_SECRETEXOPT		=>	( $ipmsg_cmd{ IPMSG_READCHECKOPT } || $ipmsg_cmd{ IPMSG_SECRETOPT } ),

	#/* ENCRYPT_FLG */
	IPMSG_RSA_512			=>	0x00000001,	#1
	IPMSG_RSA_1024			=>	0x00000002,	#2
	IPMSG_RSA_2048			=>	0x00000004,	#4
	IPMSG_RC2_40			=>	0x00001000,	#4096
	IPMSG_RC2_128			=>	0x00004000,	#16384
	IPMSG_RC2_256			=>	0x00008000,	#32768
	IPMSG_BLOWFISH_128		=>	0x00020000,	#131072
	IPMSG_BLOWFISH_256		=>	0x00040000,	#262144
	IPMSG_SIGN_MD5			=>	0x10000000,	#268435456

	#/* compatibilty for Win beta version */
	IPMSG_RC2_40OLD			=>	0x00000010,	#16		for beta1-4 only
	IPMSG_RC2_128OLD		=>	0x00000040,	#64		for beta1-4 only
	IPMSG_BLOWFISH_128OLD	=>	0x00000400,	#1024	for beta1-4 only
	IPMSG_RC2_40ALL			=>	( $ipmsg_cmd{ IPMSG_RC2_40 } || $ipmsg_cmd{ IPMSG_RC2_40OLD } ),
	IPMSG_RC2_128ALL		=>	( $ipmsg_cmd{ IPMSG_RC2_128 } || $ipmsg_cmd{ IPMSG_RC2_128OLD } ),
	IPMSG_BLOWFISH_128ALL	=>	( $ipmsg_cmd{ IPMSG_BLOWFISH_128 } || $ipmsg_cmd{ IPMSG_BLOWFISH_128OLD } ),

	#/* file types for fileattach command */
	IPMSG_FILE_REGULAR		=>	0x00000001,	#1
	IPMSG_FILE_DIR			=>	0x00000002,	#2
	IPMSG_FILE_RETPARENT	=>	0x00000003,	#3		return parent directory
	IPMSG_FILE_SYMLINK		=>	0x00000004,	#4
	IPMSG_FILE_CDEV			=>	0x00000005,	#5		for UNIX
	IPMSG_FILE_BDEV			=>	0x00000006,	#6		for UNIX
	IPMSG_FILE_FIFO			=>	0x00000007,	#7		for UNIX
	IPMSG_FILE_RESFORK		=>	0x00000010,	#16		for Mac

	#/* file attribute options for fileattach command */
	IPMSG_FILE_RONLYOPT		=>	0x00000100,	#256
	IPMSG_FILE_HIDDENOPT	=>	0x00001000,	#4096
	IPMSG_FILE_EXHIDDENOPT	=>	0x00002000,	#8192	for MacOS X
	IPMSG_FILE_ARCHIVEOPT	=>	0x00004000,	#16834
	IPMSG_FILE_SYSTEMOPT	=>	0x00008000,	#32768

	#/* extend attribute types for fileattach command */
	IPMSG_FILE_UID			=>	0x00000001,	#1
	IPMSG_FILE_USERNAME		=>	0x00000002,	#2		uid by string
	IPMSG_FILE_GID			=>	0x00000003,	#3
	IPMSG_FILE_GROUPNAME	=>	0x00000004,	#4		gid by string
	IPMSG_FILE_PERM			=>	0x00000010,	#16		for UNIX
	IPMSG_FILE_MAJORNO		=>	0x00000011,	#17		for UNIX devfile
	IPMSG_FILE_MINORNO		=>	0x00000012,	#18		for UNIX devfile
	IPMSG_FILE_CTIME		=>	0x00000013,	#19		for UNIX
	IPMSG_FILE_MTIME		=>	0x00000014,	#20
	IPMSG_FILE_ATIME		=>	0x00000015,	#21
	IPMSG_FILE_CREATETIME	=>	0x00000016,	#22
	IPMSG_FILE_CREATOR		=>	0x00000020,	#32		for Mac
	IPMSG_FILE_FILETYPE		=>	0x00000021,	#33		for Mac
	IPMSG_FILE_FINDERINFO	=>	0x00000022,	#34		for Mac
	IPMSG_FILE_ACL			=>	0x00000030,	#48
	IPMSG_FILE_ALIASFNAME	=>	0x00000040,	#64		alias fname
	IPMSG_FILE_UNICODEFNAME	=>	0x00000041,	#65		UNICODE fname

);

# --------------------
# Category: Methods

# --------------------
# Name: get_mode

sub get_mode
{
	my ( $self, $command ) = @_;
	return( $command & 0x000000ff );
}

# --------------------
# Name: get_opt

sub get_opt
{
	my ( $self, $command ) = @_;
	return( $command & 0xffffff00 );
}

# --------------------
# Name: port_L2B

sub port_L2B
{
	my ( $self, $PORT ) = @_;

	# --------------------
	# return

	return unpack( "n*", pack( "v", $PORT ) );
}

# --------------------
# Name: port_B2L

sub port_B2L
{
	my ( $self, $PORT ) = @_;

	# --------------------
	# return

	return unpack( "v", pack( "n*", $PORT ) );
}

# --------------------
# Name: as_string
#

sub as_string
{
	my ( $self, $tmp ) = @_;

	# --------------------
	# require check

	return undef if ! defined $tmp;

	# --------------------
	# replace unprintable strings

	my $DUMMY	= $self->delim_dummy;
	my $HOST	= $self->delim_hostlist;
	my $GROUP	= $self->delim_group;

	my $STR		= $self->delim_string;

	$tmp =~ s/$HOST/$STR/g;
	$tmp =~ s/$DUMMY/$STR/g;
	$tmp =~ s/$GROUP/$STR/g;

	# --------------------
	# return

	return $tmp;
}

# --------------------
# Category: Setting object

# --------------------
# Name: put_value

sub put_value
{
	my $self= shift;
	my %arg	= @_;

	# --------------------
	# check requirements

	return undef if ! %arg;

	while( my ( $name, $value ) = each ( %arg ) ){
		$self->[ $_index{ $name } ] = $value;
	}

	# --------------------
	# return

	return $self;
}

# --------------------
# Name: get_value

sub get_value
{
	my ( $self, $arg ) = @_;

	# --------------------
	# return

	return ( wantarray ? sort keys %_index : $self->[ $_index{ $arg } ] );
}

# --------------------
# Name: display

sub display
{
	my $self = shift;

	# --------------------
	# print

	foreach my $i ( sort keys %_index ){
		print "$i=>",$self->[ $_index{ $i } ],"\n";
	}

}

# --------------------
# Name: Code

sub Code
{
	my $self = shift;

	# --------------------
	# return

	return $self->[ code ];
}

# --------------------
# Name: _index

sub _index
{
	my ( $self, $index ) = @_;

	# --------------------
	# return

	return $_index{ $index };
}

1;

