/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.NamingRule;
import junit.extensions.eclipse.quick.QuickJUnitPreferencePage;
import org.eclipse.jdt.internal.junit.util.SWTUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class NamingRulesPreference {
    private QuickJUnitPreferencePage preferencePage;
    private Shell shell;
    private List namingRulesValue;
    private CheckboxTableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private Button moveUpButton;
    private Button moveDownButton;

    public NamingRulesPreference(QuickJUnitPreferencePage preferencePage) {
        this.preferencePage = preferencePage;
    }

    public void create(List namingRulesValue, Composite parent) {
        this.namingRulesValue = namingRulesValue;
        this.shell = parent.getShell();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createTable(container);
        this.createButtons(container);
        this.update();
    }

    public void setValue(List namingRulesValue) {
        this.namingRulesValue = namingRulesValue;
        this.update();
    }

    public List getValue() {
        return this.namingRulesValue;
    }

    private void createTable(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("NamingRulesPreference.label"));
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Table table = new Table(container, 67618);
        gd = new GridData(768);
        table.setLayoutData((Object)gd);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutData[0]);
        table.setLayout((Layout)tableLayout);
        new TableColumn(table, 0);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setInput((Object)this);
        gd = new GridData(1808);
        this.tableViewer.getTable().setLayoutData((Object)gd);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                NamingRule namingRule = (NamingRule)event.getElement();
                namingRule.setEnabled(event.getChecked());
                NamingRulesPreference.this.update();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NamingRulesPreference.this.updateButtons();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NamingRulesPreference.this.editNamingRule();
            }
        });
    }

    private void createButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        Object listener = new Listener(){

            public void handleEvent(Event e) {
                NamingRulesPreference.this.addNamingRule();
            }
        };
        this.addButton = this.createButton("addButton", buttonContainer, (Listener)listener, true);
        listener = new Listener(){

            public void handleEvent(Event e) {
                NamingRulesPreference.this.removeNamingRules();
            }
        };
        this.removeButton = this.createButton("removeButton", buttonContainer, (Listener)listener, false);
        this.removeButton.setEnabled(false);
        listener = new Listener(){

            public void handleEvent(Event e) {
                NamingRulesPreference.this.editNamingRule();
            }
        };
        this.editButton = this.createButton("editButton", buttonContainer, (Listener)listener, false);
        this.editButton.setEnabled(false);
        listener = new Listener(){

            public void handleEvent(Event e) {
                NamingRulesPreference.this.moveNamingRule(true);
            }
        };
        this.moveUpButton = this.createButton("moveUpButton", buttonContainer, (Listener)listener, false);
        this.moveUpButton.setEnabled(false);
        listener = new Listener(){

            public void handleEvent(Event e) {
                NamingRulesPreference.this.moveNamingRule(false);
            }
        };
        this.moveDownButton = this.createButton("moveDownButton", buttonContainer, (Listener)listener, false);
        this.moveDownButton.setEnabled(false);
    }

    private void update() {
        this.tableViewer.refresh();
        int i = 0;
        while (i < this.namingRulesValue.size()) {
            NamingRule namingRule = (NamingRule)this.namingRulesValue.get(i);
            this.tableViewer.setChecked((Object)namingRule, namingRule.isEnabled());
            ++i;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean canMove;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        this.removeButton.setEnabled(!selection.isEmpty());
        this.editButton.setEnabled(selection.size() == 1);
        int rowCount = this.tableViewer.getTable().getItemCount();
        boolean bl = canMove = selection.size() == 1 && rowCount > 1;
        if (!canMove) {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            int selectedIndex = this.namingRulesValue.indexOf(selection.getFirstElement());
            this.moveUpButton.setEnabled(selectedIndex > 0);
            this.moveDownButton.setEnabled(selectedIndex < rowCount - 1);
        }
    }

    private void editNamingRule() {
        String value;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        NamingRule rule = (NamingRule)selection.getFirstElement();
        InputDialog dialog = this.createEditDialog("editNamingRule", rule.getValue());
        if (dialog.open() == 0 && (value = dialog.getValue()).trim().length() != 0) {
            rule.setValue(value);
            this.update();
        }
    }

    private InputDialog createEditDialog(String messageId, String initValue) {
        String title = Messages.getString("NamingRulesPreference." + messageId + ".dialog.title");
        String message = Messages.getString("NamingRulesPreference." + messageId + ".dialog.message");
        return new InputDialog(this.shell, title, message, initValue, (IInputValidator)new NamingRuleValidator());
    }

    private void addNamingRule() {
        String value;
        InputDialog dialog = this.createEditDialog("addNamingRule", "");
        if (dialog.open() == 0 && (value = dialog.getValue()).trim().length() != 0) {
            NamingRule rule = new NamingRule(value, true);
            this.namingRulesValue.add(rule);
            this.update();
        }
    }

    private void removeNamingRules() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            this.namingRulesValue.remove(i.next());
        }
        this.update();
    }

    private void moveNamingRule(boolean up) {
        int newIndex;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        Object selected = selection.getFirstElement();
        int oldIndex = this.namingRulesValue.indexOf(selected);
        int n = newIndex = up ? oldIndex - 1 : oldIndex + 1;
        if (newIndex < 0 || this.namingRulesValue.size() <= newIndex) {
            return;
        }
        this.namingRulesValue.remove(oldIndex);
        this.namingRulesValue.add(newIndex, selected);
        this.update();
    }

    private Button createButton(String buttonId, Composite buttonContainer, Listener listener, boolean isTop) {
        Button button = new Button(buttonContainer, 8);
        button.setText(Messages.getString("NamingRulesPreference." + buttonId + ".label"));
        button.setToolTipText(Messages.getString("NamingRulesPreference." + buttonId + ".tooltip"));
        GridData gd = isTop ? new GridData(770) : this.preferencePage.getButtonGridData(button);
        button.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)button);
        button.addListener(13, listener);
        return button;
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object o, int column) {
            return column == 0 ? ((NamingRule)o).getValue() : "";
        }

        public String getText(Object element) {
            return ((NamingRule)element).getValue();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return NamingRulesPreference.this.namingRulesValue.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class NamingRuleValidator
    implements IInputValidator {
        NamingRuleValidator() {
        }

        public String isValid(String newText) {
            if ((newText = newText.trim()).length() == 0) {
                return Messages.getString("NamingRulesPreference.namingRuleValidator.empty");
            }
            newText = newText.replaceAll("\\$\\{package\\}", "package");
            newText = newText.replaceAll("\\$\\{type\\}", "type");
            StringTokenizer st = new StringTokenizer(newText, ".", true);
            boolean dot = false;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (dot) {
                    if (!token.equals(".")) {
                        return Messages.getString("NamingRulesPreference.namingRuleValidator.error");
                    }
                    dot = false;
                    continue;
                }
                if (!this.isJavaIdentifier(token)) {
                    return Messages.getString("NamingRulesPreference.namingRuleValidator.tokenError", token);
                }
                dot = true;
            }
            return null;
        }

        private boolean isJavaIdentifier(String token) {
            if (!Character.isJavaIdentifierStart(token.charAt(0))) {
                return false;
            }
            int i = 1;
            while (i < token.length()) {
                if (!Character.isJavaIdentifierPart(token.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

