package junit.extensions.eclipse.quick;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class QuickJUnitException extends CoreException {

    public QuickJUnitException(Throwable cause) {
        this(cause.getMessage(), cause);
    }
    public QuickJUnitException(IStatus status) {
        super(status);
    }
    public QuickJUnitException(String message) {
        this(new Status(IStatus.ERROR, QuickJUnitPlugin.ID, 0, message, null));
    }
    public QuickJUnitException(String message, Throwable cause) {
        this(new Status(IStatus.ERROR, QuickJUnitPlugin.ID, 0, message, cause));
    }
}
