/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import junit.extensions.eclipse.quick.EditorSplitter;
import junit.extensions.eclipse.quick.JavaElements;
import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.NamingRules;
import junit.extensions.eclipse.quick.PopupTableSelector;
import junit.extensions.eclipse.quick.QuickJUnitAction;
import junit.extensions.eclipse.quick.QuickJUnitPlugin;
import junit.extensions.eclipse.quick.TestingPair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IWorkbenchPart;

public class OpenTestingPairAction
extends QuickJUnitAction {
    private static final String SPLITS_EDITOR_STORE_ID = "OpenTestingPairAction.splitsEditor";
    private static final boolean SPLITS_EDITOR_DEFAULT = false;

    private IType getTypeOfJavaEditor() throws JavaModelException {
        if (this.javaEditor == null) {
            return null;
        }
        return SelectionConverter.getTypeAtOffset((JavaEditor)this.javaEditor);
    }

    private IType getTypeOfJavaElement() {
        return JavaElements.getPrimaryTypeOf(this.javaElement);
    }

    private IType selectType(IAction iAction, List list) {
        PopupTableSelector popupTableSelector = new PopupTableSelector(this.getShell(), list);
        popupTableSelector.setTitle(iAction.getText());
        popupTableSelector.setCommandForward(iAction.getActionDefinitionId());
        popupTableSelector.setLabelProvider((ILabelProvider)new TypeLabelProvider());
        return (IType)popupTableSelector.select();
    }

    public void run(IAction iAction) {
        try {
            IType iType = this.getTypeOfJavaEditor();
            if (iType == null) {
                iType = this.getTypeOfJavaElement();
            }
            if (iType == null) {
                return;
            }
            IJavaProject[] iJavaProjectArray = this.getJavaProjects();
            List list = this.findPairTypes(this.createTestPair(), iJavaProjectArray, iType);
            if (list.isEmpty()) {
                this.openInformation(iAction, Messages.getString("OpenTestingPairAction.testPairNotFound", iType.getFullyQualifiedName()));
                return;
            }
            IType iType2 = null;
            iType2 = list.size() >= 2 ? this.selectType(iAction, list) : (IType)list.get(0);
            if (iType2 != null) {
                this.openInEditor(iType2);
            }
        }
        catch (JavaModelException javaModelException) {
            QuickJUnitPlugin.getDefault().handleSystemError((Exception)((Object)javaModelException), this);
        }
        catch (CoreException coreException) {
            QuickJUnitPlugin.getDefault().handleSystemError((Exception)((Object)coreException), this);
        }
    }

    private void openInEditor(IType iType) throws CoreException {
        if (this.javaEditor == null || !OpenTestingPairAction.splitsEditor()) {
            JavaUI.openInEditor((IJavaElement)iType);
            return;
        }
        IResource iResource = iType.getResource();
        if (!(iResource instanceof IFile)) {
            JavaUI.openInEditor((IJavaElement)iType);
            return;
        }
        EditorSplitter editorSplitter = new EditorSplitter((IWorkbenchPart)this.javaEditor);
        editorSplitter.open((IFile)iResource);
    }

    private TestingPair createTestPair() {
        TestingPair testingPair = new TestingPair();
        IPreferenceStore iPreferenceStore = QuickJUnitPlugin.getDefault().getPreferenceStore();
        String[] stringArray = new NamingRules(iPreferenceStore).getEnableValues();
        for (int i = 0; i < stringArray.length; ++i) {
            testingPair.addNamingRule(stringArray[i]);
        }
        return testingPair;
    }

    private List findPairTypes(TestingPair testingPair, IJavaProject[] iJavaProjectArray, IType iType) throws JavaModelException {
        LinkedHashSet<IType> linkedHashSet = new LinkedHashSet<IType>();
        String[] stringArray = testingPair.getPairClassNames(iType.getFullyQualifiedName());
        for (int i = 0; i < iJavaProjectArray.length; ++i) {
            IJavaProject iJavaProject = iJavaProjectArray[i];
            for (int j = 0; j < stringArray.length; ++j) {
                IType iType2 = iJavaProject.findType(stringArray[j]);
                if (iType2 == null) continue;
                linkedHashSet.add(iType2);
            }
        }
        return new ArrayList(linkedHashSet);
    }

    private static void beforeAccessPreferenceStore(IPreferenceStore iPreferenceStore) {
        if (!iPreferenceStore.contains(SPLITS_EDITOR_STORE_ID)) {
            iPreferenceStore.setDefault(SPLITS_EDITOR_STORE_ID, false);
        }
    }

    static boolean splitsEditor(IPreferenceStore iPreferenceStore) {
        OpenTestingPairAction.beforeAccessPreferenceStore(iPreferenceStore);
        return iPreferenceStore.getBoolean(SPLITS_EDITOR_STORE_ID);
    }

    public static boolean splitsEditor() {
        return OpenTestingPairAction.splitsEditor(QuickJUnitPlugin.getDefault().getPreferenceStore());
    }

    static void setSplitsEditor(IPreferenceStore iPreferenceStore, boolean bl) {
        OpenTestingPairAction.beforeAccessPreferenceStore(iPreferenceStore);
        iPreferenceStore.setValue(SPLITS_EDITOR_STORE_ID, bl);
    }

    public static void setSplitsEditor(boolean bl) {
        OpenTestingPairAction.setSplitsEditor(QuickJUnitPlugin.getDefault().getPreferenceStore(), bl);
    }

    static boolean getDefaultSplitsEditor(IPreferenceStore iPreferenceStore) {
        OpenTestingPairAction.beforeAccessPreferenceStore(iPreferenceStore);
        return iPreferenceStore.getDefaultBoolean(SPLITS_EDITOR_STORE_ID);
    }

    public static boolean getDefalutSplitsEditor() {
        return OpenTestingPairAction.getDefaultSplitsEditor(QuickJUnitPlugin.getDefault().getPreferenceStore());
    }

    private static class TypeLabelProvider
    extends LabelProvider {
        private TypeLabelProvider() {
        }

        public String getText(Object object) {
            return ((IType)object).getFullyQualifiedName();
        }
    }
}

