package junit.extensions.eclipse.quick;

import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;


public class QuickJUnitPlugin extends AbstractUIPlugin {

    final public static String ID = "junit.extensions.eclipse.quick"; //$NON-NLS-1$

    private static QuickJUnitPlugin plugin;

    public QuickJUnitPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static QuickJUnitPlugin getDefault() {
        return plugin;        
    }

    public IStatus createSystemErrorStatus(Exception ex, Object caller) {
        int severity = IStatus.ERROR;

        String message;
        message  = ex.getMessage();
        if (message == null)
            message = ""; //$NON-NLS-1$
        MultiStatus errorStatus = new MultiStatus(ID, severity, message, ex);

        message = Messages.getString("QuickJUnitPlugin.systemError.providerNameLabel") + getDescriptor().getProviderName(); //$NON-NLS-1$
        errorStatus.add(createStatus(severity, message));

        message = Messages.getString("QuickJUnitPlugin.systemError.pluginNameLabel") + getDescriptor().getLabel(); //$NON-NLS-1$
        errorStatus.add(createStatus(severity, message));

        message = Messages.getString("QuickJUnitPlugin.systemError.pluginIdLabel") + ID; //$NON-NLS-1$
        errorStatus.add(createStatus(severity, message));

        String version = getDescriptor().getVersionIdentifier().toString();
        message = Messages.getString("QuickJUnitPlugin.systemError.versionLabel") + version; //$NON-NLS-1$
        errorStatus.add(createStatus(severity, message));

        Class klass = caller instanceof Class ? (Class) caller : caller.getClass();
        message = Messages.getString("QuickJUnitPlugin.systemError.classLabel") + klass.getName(); //$NON-NLS-1$
        errorStatus.add(createStatus(severity, message, IStatus.ERROR, ex));

        return errorStatus;
    }

    public IStatus createStatus(int severity, String message) {
        return createStatus(severity, message, 0, null);
    }

    private IStatus createStatus(int severity, String message, int code, Exception ex) {
        return new Status(severity, ID, code, message, ex);
    }
    
    public void handleSystemError(Exception ex, Object caller) {
        IStatus status = createSystemErrorStatus(ex, caller);
        getLog().log(status);
        ErrorDialog.openError((Shell) null, Messages.getString("QuickJUnitPlugin.systemError.dialog.title"), Messages.getString("QuickJUnitPlugin.systemError.dialog.message"), status); //$NON-NLS-1$ //$NON-NLS-2$
    }

    public void logSystemError(Exception ex, Object caller) {
        IStatus status = createSystemErrorStatus(ex, caller);
        getLog().log(status);
    }

    public void logSystemErrorMessage(String message, Object caller) {
        IStatus status = createSystemErrorStatus(new QuickJUnitException(message), caller);
        getLog().log(status);
    }
}
