/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestingPair {
    private List namingRules = new ArrayList();

    public void addNamingRule(String string) {
        this.namingRules.add(string);
    }

    public void clearNamingRules() {
        this.namingRules.clear();
    }

    public String[] getPairClassNames(String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        string = this.chopInnerClassName(string);
        this.addTestedClassNames(string, linkedHashSet);
        if (linkedHashSet.isEmpty()) {
            this.addTestClassNames(string, linkedHashSet);
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private void addTestedClassNames(String string, Set set) {
        for (int i = 0; i < this.namingRules.size(); ++i) {
            String string2 = this.getTestedClassName(string, (String)this.namingRules.get(i));
            if (string2 == null) continue;
            set.add(string2);
        }
    }

    private String escapeAllChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("\\${}?+.[]-()><!|^:=*&,".indexOf(c) != -1) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String getTestedClassName(String string, String string2) {
        int n = string.lastIndexOf(46);
        string2 = this.escapeAllChars(string2);
        if (n == -1) {
            string2 = string2.replaceAll("\\\\\\$\\\\\\{package\\\\\\}\\\\\\.", "");
            Pattern pattern = Pattern.compile(string2 = string2.replaceAll("\\\\\\$\\\\\\{type\\\\\\}", "(\\\\w+)"));
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        } else {
            Pattern pattern = Pattern.compile((string2 = string2.replaceAll("\\\\\\$\\\\\\{package\\\\\\}\\\\\\.", "(?:([\\\\w\\\\.]+)\\\\.)?")).replaceAll("\\\\\\$\\\\\\{type\\\\\\}", "(\\\\w+)"));
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                if (matcher.group(1) == null) {
                    return matcher.group(2);
                }
                return matcher.group(1) + "." + matcher.group(2);
            }
        }
        return null;
    }

    private void addTestClassNames(String string, Set set) {
        String string2;
        String string3;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string3 = string.substring(n + 1);
            string2 = string.substring(0, n);
        } else {
            string3 = string;
            string2 = null;
        }
        for (int i = 0; i < this.namingRules.size(); ++i) {
            set.add(this.getTestClassName(string2, string3, (String)this.namingRules.get(i)));
        }
    }

    private String getTestClassName(String string, String string2, String string3) {
        String string4 = new String(string3);
        string4 = string != null ? string4.replaceAll("\\$\\{package\\}", string) : string4.replaceAll("\\$\\{package\\}\\.", "");
        return string4.replaceAll("\\$\\{type\\}", string2);
    }

    private String chopInnerClassName(String string) {
        int n = string.indexOf(36);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }
}

