/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.NamingRule;
import junit.extensions.eclipse.quick.NamingRules;
import junit.extensions.eclipse.quick.QuickJUnitPlugin;
import org.eclipse.jdt.internal.junit.util.SWTUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class QuickJUnitPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List namingRulesValue;
    private NamingRules namingRules;
    private CheckboxTableViewer namingRuleViewer;
    private Button addNamingRuleButton;
    private Button removeNamingRuleButton;
    private Button editNamingRuleButton;
    private Button moveUpNamingRuleButton;
    private Button moveDownNamingRuleButton;

    public QuickJUnitPreferencePage() {
        this.setPreferenceStore(QuickJUnitPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench iWorkbench) {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.namingRules = new NamingRules(iPreferenceStore);
        this.namingRulesValue = this.namingRules.get();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        this.createNamingRulePreferences(composite2);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createNamingRulePreferences(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.createNamingRuleTable(composite2);
        this.createNamingRuleButtons(composite2);
        this.updateNamingRuleViewer();
    }

    private void createNamingRuleButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1040);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Object object = new Listener(){

            public void handleEvent(Event event) {
                QuickJUnitPreferencePage.this.addNamingRule();
            }
        };
        this.addNamingRuleButton = this.createButton("addNamingRuleButton", composite2, (Listener)object, true);
        object = new Listener(){

            public void handleEvent(Event event) {
                QuickJUnitPreferencePage.this.removeNamingRules();
            }
        };
        this.removeNamingRuleButton = this.createButton("removeNamingRuleButton", composite2, (Listener)object, false);
        this.removeNamingRuleButton.setEnabled(false);
        object = new Listener(){

            public void handleEvent(Event event) {
                QuickJUnitPreferencePage.this.editNamingRule();
            }
        };
        this.editNamingRuleButton = this.createButton("editNamingRuleButton", composite2, (Listener)object, false);
        this.editNamingRuleButton.setEnabled(false);
        object = new Listener(){

            public void handleEvent(Event event) {
                QuickJUnitPreferencePage.this.moveNamingRule(true);
            }
        };
        this.moveUpNamingRuleButton = this.createButton("moveUpNamingRuleButton", composite2, (Listener)object, false);
        this.moveUpNamingRuleButton.setEnabled(false);
        object = new Listener(){

            public void handleEvent(Event event) {
                QuickJUnitPreferencePage.this.moveNamingRule(false);
            }
        };
        this.moveDownNamingRuleButton = this.createButton("moveDownNamingRuleButton", composite2, (Listener)object, false);
        this.moveDownNamingRuleButton.setEnabled(false);
    }

    private Button createButton(String string, Composite composite, Listener listener, boolean bl) {
        Button button = new Button(composite, 8);
        button.setText(Messages.getString("QuickJUnitPreferencePage." + string + ".label"));
        button.setToolTipText(Messages.getString("QuickJUnitPreferencePage." + string + ".tooltip"));
        GridData gridData = bl ? new GridData(770) : this.getButtonGridData(button);
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint((Button)button);
        button.addListener(13, listener);
        return button;
    }

    private void addNamingRule() {
        String string;
        InputDialog inputDialog = this.createNamingRuleEditDialog("addNamingRule", "");
        if (inputDialog.open() == 0 && (string = inputDialog.getValue()).trim().length() != 0) {
            NamingRule namingRule = new NamingRule(string, true);
            this.namingRulesValue.add(namingRule);
            this.updateNamingRuleViewer();
        }
    }

    private void removeNamingRules() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.namingRuleViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            this.namingRulesValue.remove(iterator.next());
        }
        this.updateNamingRuleViewer();
    }

    private void editNamingRule() {
        String string;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.namingRuleViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        NamingRule namingRule = (NamingRule)iStructuredSelection.getFirstElement();
        InputDialog inputDialog = this.createNamingRuleEditDialog("editNamingRule", namingRule.getValue());
        if (inputDialog.open() == 0 && (string = inputDialog.getValue()).trim().length() != 0) {
            namingRule.setValue(string);
            this.updateNamingRuleViewer();
        }
    }

    private InputDialog createNamingRuleEditDialog(String string, String string2) {
        String string3 = Messages.getString("QuickJUnitPreferencePage." + string + ".dialog.title");
        String string4 = Messages.getString("QuickJUnitPreferencePage." + string + ".dialog.message");
        return new InputDialog(this.getShell(), string3, string4, string2, (IInputValidator)new NamingRuleValidator());
    }

    protected void moveNamingRule(boolean bl) {
        int n;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.namingRuleViewer.getSelection();
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() > 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        int n2 = this.namingRulesValue.indexOf(object);
        int n3 = n = bl ? n2 - 1 : n2 + 1;
        if (n < 0 || this.namingRulesValue.size() <= n) {
            return;
        }
        this.namingRulesValue.remove(n2);
        this.namingRulesValue.add(n, object);
        this.updateNamingRuleViewer();
    }

    private GridData getButtonGridData(Button button) {
        GridData gridData = new GridData(770);
        int n = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        return gridData;
    }

    private void createNamingRuleTable(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("QuickJUnitPreferencePage.namingRule.label"));
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Table table = new Table(composite, 67618);
        gridData = new GridData(768);
        table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutDataArray[0]);
        table.setLayout((Layout)tableLayout);
        new TableColumn(table, 0);
        this.namingRuleViewer = new CheckboxTableViewer(table);
        this.namingRuleViewer.setLabelProvider((IBaseLabelProvider)new NamingRuleTableLabelProvider());
        this.namingRuleViewer.setContentProvider((IContentProvider)new NamingRuleTableContentProvider());
        this.namingRuleViewer.setInput((Object)this);
        gridData = new GridData(1808);
        this.namingRuleViewer.getTable().setLayoutData((Object)gridData);
        this.namingRuleViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                NamingRule namingRule = (NamingRule)checkStateChangedEvent.getElement();
                namingRule.setEnabled(checkStateChangedEvent.getChecked());
                QuickJUnitPreferencePage.this.updateNamingRuleViewer();
            }
        });
        this.namingRuleViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                QuickJUnitPreferencePage.this.updateNamingRuleButtons();
            }
        });
        this.namingRuleViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                QuickJUnitPreferencePage.this.editNamingRule();
            }
        });
    }

    private void updateNamingRuleViewer() {
        this.namingRuleViewer.refresh();
        for (int i = 0; i < this.namingRulesValue.size(); ++i) {
            NamingRule namingRule = (NamingRule)this.namingRulesValue.get(i);
            this.namingRuleViewer.setChecked((Object)namingRule, namingRule.isEnabled());
        }
        this.updateNamingRuleButtons();
    }

    private void updateNamingRuleButtons() {
        boolean bl;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.namingRuleViewer.getSelection();
        this.removeNamingRuleButton.setEnabled(!iStructuredSelection.isEmpty());
        this.editNamingRuleButton.setEnabled(iStructuredSelection.size() == 1);
        int n = this.namingRuleViewer.getTable().getItemCount();
        boolean bl2 = bl = iStructuredSelection.size() == 1 && n > 1;
        if (!bl) {
            this.moveUpNamingRuleButton.setEnabled(false);
            this.moveDownNamingRuleButton.setEnabled(false);
        } else {
            int n2 = this.namingRulesValue.indexOf(iStructuredSelection.getFirstElement());
            this.moveUpNamingRuleButton.setEnabled(0 < n2);
            this.moveDownNamingRuleButton.setEnabled(n2 < n - 1);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.namingRulesValue = this.namingRules.getDefault();
        this.updateNamingRuleViewer();
    }

    public boolean performOk() {
        this.namingRules.set(this.namingRulesValue);
        QuickJUnitPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private class NamingRuleTableContentProvider
    implements IStructuredContentProvider {
        private NamingRuleTableContentProvider() {
        }

        public Object[] getElements(Object object) {
            return QuickJUnitPreferencePage.this.namingRulesValue.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class NamingRuleTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private NamingRuleTableLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            return n == 0 ? ((NamingRule)object).getValue() : "";
        }

        public String getText(Object object) {
            return ((NamingRule)object).getValue();
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }
    }

    private static class NamingRuleValidator
    implements IInputValidator {
        private NamingRuleValidator() {
        }

        public String isValid(String string) {
            if ((string = string.trim()).length() == 0) {
                return Messages.getString("QuickJUnitPreferencePage.namingRuleValidator.empty");
            }
            string = string.replaceAll("\\$\\{package\\}", "package");
            string = string.replaceAll("\\$\\{type\\}", "type");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (bl) {
                    if (!string2.equals(".")) {
                        return Messages.getString("QuickJUnitPreferencePage.namingRuleValidator.error");
                    }
                    bl = false;
                    continue;
                }
                if (!this.isJavaIdentifier(string2)) {
                    return Messages.getString("QuickJUnitPreferencePage.namingRuleValidator.tokenError", string2);
                }
                bl = true;
            }
            return null;
        }

        private boolean isJavaIdentifier(String string) {
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                return false;
            }
            for (int i = 1; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

