/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.NamingRules;
import junit.extensions.eclipse.quick.PopupTableSelector;
import junit.extensions.eclipse.quick.QuickJUnitAction;
import junit.extensions.eclipse.quick.QuickJUnitPlugin;
import junit.extensions.eclipse.quick.TestingPair;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.PartInitException;

public class OpenTestingPairAction
extends QuickJUnitAction {
    private IType getTypeOfJavaEditor() throws JavaModelException {
        if (this.javaEditor == null) {
            return null;
        }
        return SelectionConverter.getTypeAtOffset((JavaEditor)this.javaEditor);
    }

    private IType getTypeOfJavaElement() {
        if (this.javaElement == null) {
            return null;
        }
        ICompilationUnit iCompilationUnit = null;
        if (this.javaElement instanceof ICompilationUnit) {
            iCompilationUnit = (ICompilationUnit)this.javaElement;
        } else if (this.javaElement instanceof IMember) {
            iCompilationUnit = ((IMember)this.javaElement).getCompilationUnit();
        }
        return iCompilationUnit != null ? iCompilationUnit.findPrimaryType() : null;
    }

    private IType selectType(IAction iAction, List list) {
        PopupTableSelector popupTableSelector = new PopupTableSelector(this.getShell(), list);
        popupTableSelector.setTitle(iAction.getText());
        popupTableSelector.setCommandForward(iAction.getActionDefinitionId());
        popupTableSelector.setLabelProvider((ILabelProvider)new TypeLabelProvider());
        return (IType)popupTableSelector.select();
    }

    public void run(IAction iAction) {
        try {
            IType iType = this.getTypeOfJavaEditor();
            if (iType == null) {
                iType = this.getTypeOfJavaElement();
            }
            if (iType == null) {
                return;
            }
            IJavaProject[] iJavaProjectArray = this.getJavaProjects();
            List list = this.findPairTypes(this.createTestPair(), iJavaProjectArray, iType);
            if (list.isEmpty()) {
                this.openInformation(iAction, Messages.getString("OpenTestingPairAction.testPairNotFound", iType.getFullyQualifiedName()));
                return;
            }
            IType iType2 = null;
            iType2 = list.size() >= 2 ? this.selectType(iAction, list) : (IType)list.get(0);
            if (iType2 != null) {
                JavaUI.openInEditor((IJavaElement)iType2);
            }
        }
        catch (JavaModelException javaModelException) {
            QuickJUnitPlugin.getDefault().handleSystemError((Exception)((Object)javaModelException), this);
        }
        catch (PartInitException partInitException) {
            QuickJUnitPlugin.getDefault().handleSystemError((Exception)((Object)partInitException), this);
        }
    }

    private TestingPair createTestPair() {
        TestingPair testingPair = new TestingPair();
        IPreferenceStore iPreferenceStore = QuickJUnitPlugin.getDefault().getPreferenceStore();
        String[] stringArray = new NamingRules(iPreferenceStore).getEnableValues();
        for (int i = 0; i < stringArray.length; ++i) {
            testingPair.addNamingRule(stringArray[i]);
        }
        return testingPair;
    }

    private List findPairTypes(TestingPair testingPair, IJavaProject[] iJavaProjectArray, IType iType) throws JavaModelException {
        LinkedHashSet<IType> linkedHashSet = new LinkedHashSet<IType>();
        String[] stringArray = testingPair.getPairClassNames(iType.getFullyQualifiedName());
        for (int i = 0; i < iJavaProjectArray.length; ++i) {
            IJavaProject iJavaProject = iJavaProjectArray[i];
            for (int j = 0; j < stringArray.length; ++j) {
                IType iType2 = iJavaProject.findType(stringArray[j]);
                if (iType2 == null) continue;
                linkedHashSet.add(iType2);
            }
        }
        return new ArrayList(linkedHashSet);
    }

    private static class TypeLabelProvider
    extends LabelProvider {
        private TypeLabelProvider() {
        }

        public String getText(Object object) {
            return ((IType)object).getFullyQualifiedName();
        }
    }
}

