/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.QuickJUnitAction;
import junit.extensions.eclipse.quick.QuickJUnitPlugin;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class JUnitLaunchAction
extends QuickJUnitAction {
    private String mode;
    private ILaunchShortcut launchShortcut;

    public JUnitLaunchAction(ILaunchShortcut iLaunchShortcut, String string) {
        this.launchShortcut = iLaunchShortcut;
        this.mode = string;
    }

    private IJavaElement getElementOfJavaEditor() throws JavaModelException {
        if (this.javaEditor == null) {
            return null;
        }
        IJavaElement iJavaElement = SelectionConverter.getElementAtOffset((JavaEditor)this.javaEditor);
        if (this.isTestMethod(iJavaElement)) {
            return iJavaElement;
        }
        return this.getTypeOfJavaElement(iJavaElement);
    }

    private boolean isTestMethod(IJavaElement iJavaElement) throws JavaModelException {
        if (!(iJavaElement instanceof IMethod)) {
            return false;
        }
        IMethod iMethod = (IMethod)iJavaElement;
        if (iMethod.getNumberOfParameters() != 0) {
            return false;
        }
        if (!iMethod.getReturnType().equals("V")) {
            return false;
        }
        int n = iMethod.getFlags();
        return Flags.isPublic((int)n) && !Flags.isStatic((int)n);
    }

    private IJavaElement getTargetElement(IAction iAction) throws JavaModelException {
        IJavaElement iJavaElement = this.getSelectedElement();
        if (iJavaElement == null || iJavaElement.getElementType() < 5) {
            return iJavaElement;
        }
        IType iType = this.getTypeOfJavaElement(iJavaElement);
        if (iType == null) {
            return iJavaElement;
        }
        ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
        IType[] iTypeArray = iTypeHierarchy.getAllInterfaces();
        for (int i = 0; i < iTypeArray.length; ++i) {
            IType iType2 = iTypeArray[i];
            if (!iType2.getFullyQualifiedName().equals("junit.framework.Test")) continue;
            return iJavaElement;
        }
        this.openInformation(iAction, Messages.getString("JUnitLaunchAction.notJUnitElement"));
        return null;
    }

    private IType getTypeOfJavaElement(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        ICompilationUnit iCompilationUnit = null;
        if (iJavaElement instanceof ICompilationUnit) {
            iCompilationUnit = (ICompilationUnit)iJavaElement;
        } else if (iJavaElement instanceof IMember) {
            iCompilationUnit = ((IMember)iJavaElement).getCompilationUnit();
        }
        return iCompilationUnit != null ? iCompilationUnit.findPrimaryType() : null;
    }

    private IJavaElement getSelectedElement() throws JavaModelException {
        IJavaElement iJavaElement = this.getElementOfJavaEditor();
        return iJavaElement == null ? this.javaElement : iJavaElement;
    }

    public void run(IAction iAction) {
        try {
            IJavaElement iJavaElement = this.getTargetElement(iAction);
            if (iJavaElement == null) {
                return;
            }
            StructuredSelection structuredSelection = new StructuredSelection(new Object[]{iJavaElement});
            this.launchShortcut.launch((ISelection)structuredSelection, this.mode);
        }
        catch (JavaModelException javaModelException) {
            QuickJUnitPlugin.getDefault().handleSystemError((Exception)((Object)javaModelException), this);
        }
    }
}

