/* DecoderContext.c */
/* 2008/11/05       */

#include "StdAfx.h"

#include "DecoderContext.h"

/* */

Error_t* Error_Create(
	MemoryPool_t* pool,
	const char*   type,
	const char*   message,
	UINT32        code,
	VOID*         eip,
	Error_t*      next)
{
	Error_t* e = (Error_t*)QV_MemoryPool_Allocate(pool, sizeof(Error_t));
	if (e == NULL) {
		return NULL;
	}

	e->Type    = type;
	e->Message = message;
	e->Code    = code;
	e->EIP     = eip;
	e->Next    = next;

	return e;
}

DECLSPEC_NAKED VOID* Error_GetEIP()
{
    __asm mov eax, [esp];
    __asm ret;
}

/* */

INT32 ilog(UINT32 n)
{
	static const INT32 LOG2_4[16] = { 0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4 };

	if (n < (1U << 14)) {
		if      (n < (1U <<  4)) return  0 + LOG2_4[n      ];
		else if (n < (1U <<  9)) return  5 + LOG2_4[n >>  5];
		else                     return 10 + LOG2_4[n >> 10];

	} else if (n < (1U << 24)) {
		if (n < (1U << 19))      return 15 + LOG2_4[n >> 15];
		else                     return 20 + LOG2_4[n >> 20];

	} else if (n < (1U << 29)) {
		return 25 + LOG2_4[n >> 25];

	} else if (n < (1U << 31)) {
		return 30 + LOG2_4[n >> 30];
	}

	return 0;
}

/* */

