/* MemoryPool.c */
/* 2009/05/14 */

#include "StdAfx.h"

#include "MemoryPool.h"

struct MemoryBlock;

typedef struct MemoryBlock MemoryBlock_t;

struct MemoryBlock {

	MemoryBlock_t* Next;

	SIZE_T Size;

	UINT32 Padding[2];

};

/* */

void QT_MemoryPool_Init(
	MemoryPool_t* t)
{
	t->Block     = NULL;
	t->TotalSize = 0;
}

void QT_MemoryPool_Release(
	MemoryPool_t* t)
{
	MemoryBlock_t* p = (MemoryBlock_t*)(t->Block);
	while (p != NULL) {
		MemoryBlock_t* n = p->Next;
		_aligned_free(p);
		p = n;
	}

	t->Block     = NULL;
	t->TotalSize = 0;
}

VOID* QT_MemoryPool_Allocate(
	MemoryPool_t* t,
	SIZE_T        cb)
{
	MemoryBlock_t* b = (MemoryBlock_t*)_aligned_malloc(
		sizeof(MemoryBlock_t) + cb,
		0x10);
	if (b == NULL) {
		return NULL;
	}

	b->Next = t->Block;
	b->Size = cb;

	t->Block      = b;
	t->TotalSize += cb;

	return b + 1;
}

/* */

