/* BlockIndex.c */
/* 2009/05/14   */

#include "StdAfx.h"

#include "BlockIndex.h"

/* */

static const INT32 S_DX[16] = {
	0, 1, 1, 0,
	0, 0, 1, 1,
	2, 2, 3, 3,
	3, 2, 2, 3
};

static const INT32 S_DY[16] = {
	0, 0, 1, 1,
	2, 3, 3, 2,
	2, 3, 3, 2,
	1, 1, 0, 0
};

/* */

static BOOL SetupBIndex(
	BlockIndex_t* t,
	MemoryPool_t* pool)
{
	INT32 i;
	for (i = 0; i < 2; i++) {
		INT32 x, y;

		UINT16* p = (UINT16*)QT_MemoryPool_Allocate(pool, sizeof(UINT16) * t->BC[i]);
		UINT8*  c = (UINT8* )QT_MemoryPool_Allocate(pool, sizeof(UINT8 ) * t->SC[i]);

		if (p == NULL || c == NULL) {
			return FALSE;
		}

		t->BIndex[i] = p;
		t->BCount[i] = c;

		for (y = 0; y < t->SY[i]; y++) {
			for (x = 0; x < t->SX[i]; x++) {
				INT32 j, b = 0;
				for (j = 0; j < 16; j++) {
					INT32 xx = x * 4 + S_DX[j];
					INT32 yy = y * 4 + S_DY[j];

					if (xx < t->BX[i] && yy < t->BY[i]) {
						*(p++) = yy * t->BX[i] + xx;
						b++;
					}
				}

				*(c++) = b;
			}
		}
	}

	t->BIndex[2] = t->BIndex[1];
	t->BCount[2] = t->BCount[1];

	return TRUE;
}

/* */

static const INT32 M_DX[4] = {
	0, 0,
	1, 1
};

static const INT32 M_DY[4] = {
	0, 1,
	1, 0
};

/* */

static BOOL SetupMBIndex(
	BlockIndex_t* t,
	MemoryPool_t* pool)
{
	INT32 x, y, j, k;

	/* Y-Plane */
	UINT16* p = (UINT16*)QT_MemoryPool_Allocate(pool, sizeof(UINT16) * t->BC[0]);
	if (p == NULL) {
		return FALSE;
	}

	t->MBIndex = p;

	for (y = 0; y < t->SY[0]; y++) {
		for (x = 0; x < t->SX[0]; x++) {
			for (j = 0; j < 4; j++) {
				INT32 xx = x * 2 + M_DX[j];
				INT32 yy = y * 2 + M_DY[j];

				if (xx < t->MX && yy < t->MY) {
					for (k = 0; k < 4; k++) {
						/* Raster Order (INTER_MV_FOUR) */
						INT32 bx = xx * 2 + (k % 2);
						INT32 by = yy * 2 + (k / 2);

						*(p++) = by * t->BX[0] + bx;
					}
				}
			}
		}
	}

	return TRUE;
}

static BOOL SetupCBIndex(
	BlockIndex_t* t,
	MemoryPool_t* pool)
{
	INT32 cx = (t->MX + 1) / 2;
	INT32 cy = (t->MY + 1) / 2;

	INT32 x, y, j;

	/* C-Plane */
	UINT16* p = (UINT16*)QT_MemoryPool_Allocate(pool, sizeof(UINT16) * t->BC[1]);
	if (p == NULL) {
		return FALSE;
	}

	t->CBIndex = p;

	for (y = 0; y < cy; y++) {
		for (x = 0; x < cx; x++) {
			for (j = 0; j < 4; j++) {
				INT32 xx = x * 2 + M_DX[j];
				INT32 yy = y * 2 + M_DY[j];

				if (xx < t->BX[1] && yy < t->BY[1]) {
					*(p++) = yy * t->BX[1] + xx;
				}
			}
		}
	}

	return TRUE;
}

/* */

BOOL BlockIndex_Setup(
	BlockIndex_t* t,
	MemoryPool_t* pool,
	INT32         mx,
	INT32         my)
{
	INT32 i;
	INT32 bx, by;

	if (mx <= 0 || my <= 0) {
		return FALSE;
	}

	bx = mx * 2;
	by = my * 2;

	if (bx > 1024 || by > 1024 || bx * by > 0x10000) {
		return FALSE;
	}

	t->MX = mx;
	t->MY = my;
	t->MC = mx * my;

	for (i = 0; i < 2; i++, bx /= 2, by /= 2) {
		t->BX[i] = bx;
		t->BY[i] = by;
		t->BC[i] = bx * by;
	}

	t->BX[2] = t->BX[1];
	t->BY[2] = t->BY[1];
	t->BC[2] = t->BC[1];

	for (i = 0; i < 2; i++) {
		t->SX[i] = (t->BX[i] + 3) / 4;
		t->SY[i] = (t->BY[i] + 3) / 4;
		t->SC[i] = t->SX[i] * t->SY[i];
	}

	t->SX[2] = t->SX[1];
	t->SY[2] = t->SY[1];
	t->SC[2] = t->SC[1];

	if (!SetupBIndex(t, pool)) {
		return FALSE;
	}

	if (!SetupMBIndex(t, pool)) {
		return FALSE;
	}

	if (!SetupCBIndex(t, pool)) {
		return FALSE;
	}

	t->Blocks  = t->BC[0] + t->BC[1] + t->BC[2];
	t->SBlocks = t->SC[0] + t->SC[1] + t->SC[2];

	return TRUE;
}

