/* Utils.c    */
/* 2009/05/21 */

#include "StdAfx.h"

#include "Utils.h"

/* */

static VOID* s_allocate(VOID* ctx, SIZE_T sz)
{
	return _aligned_malloc(sz, 0x10);
}

static VOID* s_reallocate(VOID* ctx, VOID* pv, SIZE_T sz)
{
	return _aligned_realloc(pv, sz, 0x10);
}

static VOID s_free(VOID* ctx, VOID* pv)
{
	_aligned_free(pv);
}

QM_Allocator_t* Allocator_Get()
{
	static QM_Allocator_t s_allocator = {
		0,
		s_allocate,
		s_reallocate,
		s_free
	};

	return &s_allocator;
}

/* */

static INT32 s_read(VOID* ctx, VOID* pv, INT32 sz)
{
	return fread(pv, 1, sz, (FILE*)ctx);
}

static BOOL  s_seek(VOID* ctx, INT64 pos)
{
	if (_fseeki64((FILE*)ctx, pos, SEEK_SET) != 0) {
		return FALSE;
	}
	return TRUE;
}

void QM_StreamReader_Init(
	QM_StreamReader_t* t,
	FILE*              fp)
{
	t->Context = fp;

	t->Read = s_read;
	t->Seek = s_seek;
}

/* */

static INT32 s_reads(VOID* ctx, VOID* pv, INT32 sz)
{
	IStream* p = (IStream*)ctx;
	ULONG cb = 0;
	HRESULT hRslt = p->lpVtbl->Read(p, pv, sz, &cb);
	if (FAILED(hRslt)) {
		return 0;
	}
	return cb;
}

static BOOL  s_seeks(VOID* ctx, INT64 pos)
{
	IStream* p = (IStream*)ctx;
	LARGE_INTEGER  li;
	ULARGE_INTEGER np;
	HRESULT hRslt;
	li.QuadPart = pos;
	hRslt = p->lpVtbl->Seek(p, li, STREAM_SEEK_SET, &np);
	if (FAILED(hRslt)) {
		return FALSE;
	}
	return TRUE;
}

void QM_StreamReader_IStream(
	QM_StreamReader_t* t,
	IStream*           p)
{
	t->Context = p;

	t->Read = s_reads;
	t->Seek = s_seeks;
}

/* */

struct MemoryBlock;

typedef struct MemoryBlock MemoryBlock_t;

struct MemoryBlock {

	MemoryBlock_t* Next;

	SIZE_T Size;

	UINT32 Padding[2];

};

/* */

void QM_MemoryPool_Init(
	QM_MemoryPool_t* t)
{
	t->Block     = NULL;
	t->TotalSize = 0;
}

void QM_MemoryPool_Release(
	QM_MemoryPool_t* t,
	QM_Allocator_t*  alloc)
{
	MemoryBlock_t* p = (MemoryBlock_t*)(t->Block);
	while (p != NULL) {
		MemoryBlock_t* n = p->Next;
		alloc->Free(alloc->Context, p);
		p = n;
	}

	t->Block     = NULL;
	t->TotalSize = 0;
}

VOID* QM_MemoryPool_Allocate(
	QM_MemoryPool_t* t,
	QM_Allocator_t*  alloc,
	SIZE_T           cb)
{
	MemoryBlock_t* b = (MemoryBlock_t*)alloc->Allocate(
		alloc->Context,
		sizeof(MemoryBlock_t) + cb);
	if (b == NULL) {
		return NULL;
	}

	b->Next = t->Block;
	b->Size = cb;

	t->Block      = b;
	t->TotalSize += cb;

	return b + 1;
}

/* */

