/* MatroskaReader.h */
/* 2009/05/21       */

#pragma once

#include "Matroska.h"

#include "MatroskaIds.h"

#include "Utils.h"

#include "StreamView.h"

/* */

#define META_INFO   0
#define META_TRACKS 1
#define META_CUES   2
#define META_SEEK   3

#define META_SEEK_ENTRIES 4

/* */

struct Tracks;

typedef struct Tracks Tracks_t;

/* */

struct MatroskaReader {

	QM_Allocator_t* Allocator;

	QM_MemoryPool_t Pool;

	StreamView_t View;

	INT64 MetaOrigin;

	INT64 MetaPosition[META_SEEK_ENTRIES];

	INT64  TimeCodeScale;
	DOUBLE Duration;

	Tracks_t* TrackList;
	INT32     TrackCount;

	QM_Track_t* Tracks;

	QM_QuePoint_t* QuePoints;
	INT32          QuePointSize;

	INT32          QuePointCount;

	INT64* Clusters;
	INT32  ClusterSize;

	INT32  ClusterCount;

	INT32 State;

	INT64 ClusterPos;
	INT64 ClusterEnd;

	INT64 ClusterTime;

	UINT8* Block;

}; /* MatroskaReader */

typedef struct MatroskaReader MatroskaReader_t;

/* */

BOOL MatroskaReader_Init(
	MatroskaReader_t* t,
	QM_Allocator_t*   allocator);

BOOL MatroskaReader_Open(
	MatroskaReader_t*  t,
	QM_StreamReader_t* reader);

void MatroskaReader_Release(
	MatroskaReader_t* t);

/* */

INT32 MatroskaReader_Read(
	MatroskaReader_t*  t,
	QM_Block_t*        block);

/* */

BOOL MatroskaReader_SeekCluster(
	MatroskaReader_t* t,
	INT64             cpos);

/* */

INT64 MatroskaReader_LookupCluster(
	MatroskaReader_t* t,
	INT64             ts);

/* */

