/* BlockLacing.h */
/* 2009/05/27    */

#pragma once

#include "Matroska.h"

#include "MemoryAllocator.h"

/* */

struct BlockLacing {

	QM_Allocator_t* Allocator;

	INT32* Length;
	INT32  LenSize;

	UINT8* Buffer;
	INT32  Size;

	const UINT8* p;

	INT32 Index;
	INT32 Count;

}; /* BlockLacing */

typedef struct BlockLacing BlockLacing_t;

/* */

BOOL BlockLacing_Create(
	BlockLacing_t*  t,
	QM_Allocator_t* allocator,
	INT32           size);

void BlockLacing_Release(
	BlockLacing_t* t);

BOOL BlockLacing_Decode(
	BlockLacing_t* t,
	const VOID*    payload,
	INT32          size,
	INT32          flag);

INT32 BlockLacing_ReadNext(
	BlockLacing_t* t,
	QM_Frame_t*    frame);

/* */

