// QPinVideo.h
// 2009/05/29

#pragma once

// QPinVideo
class ATL_NO_VTABLE QPinVideo :
	public ATL::CComObjectRootEx<ATL::CComMultiThreadModel>,

	public QPinImpl<QPinVideo> {

	enum {
		MI_YUY2,
		MI_YV12,

		MTYPES
	};

	VIDEOINFOHEADER2 m_VideoHeader;

public:

	DECLARE_NOT_AGGREGATABLE(QPinVideo)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(QPinVideo)
		COM_INTERFACE_ENTRY(IPin)
	END_COM_MAP()

public:

	QPinVideo()
	{
		memset(&m_VideoHeader, 0, sizeof(m_VideoHeader));
	}

	~QPinVideo()
	{
	}

	HRESULT Init(
		QPinHost*    host,
		IBaseFilter* p)
	{
		QPinImpl<QPinVideo>::Init(host, p, L"Video");

		return S_OK;
	}

	HRESULT FinalConstruct()
	{
		ATLTRACE("QPinVideo::FinalConstruct()\n");

		return S_OK;
	}

	void FinalRelease()
	{
		ATLTRACE("QPinVideo::FinalRelease()\n");
	}

	/* */

	void SetupVideoFormat(
		const QT_Format_t* fmt,
		INT64              rate)
	{
		SetupMediaTypes(MTYPES);

		QMediaType* mt = MediaTypes();

		mt[MI_YUY2].SetVideo(QMediaType::VID_YUY2, fmt, rate);
		mt[MI_YV12].SetVideo(QMediaType::VID_YV12, fmt, rate);
	}

	const VIDEOINFOHEADER2* GetVideoHeader()
	{
		return &m_VideoHeader;
	}

	/* */

	HRESULT SetupAllocator(
		IMemAllocator*       alloc,
		const AM_MEDIA_TYPE* target)
	{
		HRESULT hRslt = CheckAccept(target);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		ALLOCATOR_PROPERTIES rprop = { 0 };
		ALLOCATOR_PROPERTIES aprop = { 0 };

		rprop.cBuffers = 15;
		rprop.cbBuffer = target->lSampleSize;
		rprop.cbAlign  = 1;
		rprop.cbPrefix = 0;

		hRslt = alloc->SetProperties(
			&rprop,
			&aprop);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	HRESULT CheckAccept(
		const AM_MEDIA_TYPE* pmt)
	{
		if (pmt->majortype != MEDIATYPE_Video) {
			return VFW_E_TYPE_NOT_ACCEPTED;
		}

		if (pmt->formattype == FORMAT_VideoInfo2        &&
			pmt->cbFormat   >= sizeof(VIDEOINFOHEADER2) &&
			pmt->pbFormat   != 0) {

			const VIDEOINFOHEADER2* v   = (const VIDEOINFOHEADER2*)(pmt->pbFormat);
			const BITMAPINFOHEADER* bmi = &(v->bmiHeader);

			ATLTRACE("SIZE: %d, %d\n", bmi->biWidth, bmi->biHeight);
			ATLTRACE("SRCR: %d, %d - %d, %d\n", v->rcSource.left, v->rcSource.top, v->rcSource.right, v->rcSource.bottom);

			memcpy(&m_VideoHeader, v, sizeof(VIDEOINFOHEADER2));

		} else {
			return VFW_E_TYPE_NOT_ACCEPTED;
		}

		return S_OK;
	}

	/* */

}; // QPinVideo

