// QPinEnum.h
// 2009/06/01

#pragma once

// QEnumPins
class ATL_NO_VTABLE QEnumPins :
	public ATL::CComObjectRootEx<ATL::CComMultiThreadModel>,

	public IEnumPins {

	ATL::CComCriticalSection m_cs;

	IPin** m_pStart;
	IPin** m_pEnd;

	IPin** m_p;

	ATL::CComPtr<IUnknown> m_Filter;

public:

	DECLARE_NOT_AGGREGATABLE(QEnumPins)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(QEnumPins)
		COM_INTERFACE_ENTRY(IEnumPins)
	END_COM_MAP()

public:

	QEnumPins() : m_pStart(0), m_pEnd(0), m_p(0)
	{
	}

	~QEnumPins()
	{
	}

	HRESULT FinalConstruct()
	{
		ATLTRACE("QEnumPins::FinalConstruct()\n");

		HRESULT hRslt = m_cs.Init();
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	void FinalRelease()
	{
		ATLTRACE("QEnumPins::FinalRelease()\n");

		m_Filter.Release();
	}

	void Init(IPin** s, IPin** e, IUnknown* p)
	{
		m_pStart = s;
		m_pEnd   = e;

		m_p = m_pStart;

		m_Filter = p;
	}

	/* */

	static HRESULT Create(IPin** s, IPin** e, IUnknown* p, IEnumPins** ppEnum)
	{
		if (ppEnum == 0) {
			return E_INVALIDARG;
		}

		ATL::CComObject<QEnumPins>* obj = 0;

		HRESULT hRslt = ATL::CComObject<QEnumPins>::CreateInstance(&obj);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		obj->Init(s, e, p);

		hRslt = obj->QueryInterface(ppEnum);
		if (FAILED(hRslt)) {
			delete obj;
			return hRslt;
		}

		return S_OK;
	}

	/* */

	STDMETHOD(Next)(
		ULONG  cPins,
		IPin** ppPins,
		ULONG* pcFetched)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		if (ppPins == 0) {
			return E_INVALIDARG;
		}

		if (pcFetched == 0 && cPins != 1) {
			return E_INVALIDARG;
		}

		ULONG i;
		IPin** pp = ppPins;
		for (i = 0; i < cPins && m_p < m_pEnd; i++, pp++, m_p++) {
			*pp = *m_p;
			if (*pp != 0) {
				(*pp)->AddRef();
			}
		}

		if (pcFetched != 0) {
			*pcFetched = i;
		}

		if (i == 0) {
			return S_FALSE;
		}

		return S_OK;
	}

	STDMETHOD(Skip)(
		ULONG cPins)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		m_p += cPins;

		if (m_p > m_pEnd) {
			m_p = m_pEnd;
		}

		return S_OK;
	}


	STDMETHOD(Reset)(void)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		m_p = m_pStart;

		return S_OK;
	}

	STDMETHOD(Clone)( 
		IEnumPins** ppEnum)
	{
		ATL::CComCritSecLock<ATL::CComCriticalSection> lock(m_cs);

		HRESULT hRslt = Create(m_pStart, m_pEnd, m_Filter, ppEnum);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	/* */

}; // QEnumPins

