// QPinAudio.h
// 2009/05/29

#pragma once

// QPinAudio
class ATL_NO_VTABLE QPinAudio :
	public ATL::CComObjectRootEx<ATL::CComMultiThreadModel>,

	public QPinImpl<QPinAudio> {

	enum {
		MI_PCM,

		MTYPES
	};

	WAVEFORMATEX m_WaveHeader;

public:

	DECLARE_NOT_AGGREGATABLE(QPinAudio)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	BEGIN_COM_MAP(QPinAudio)
		COM_INTERFACE_ENTRY(IPin)
	END_COM_MAP()

public:

	QPinAudio()
	{
		memset(&m_WaveHeader, 0, sizeof(m_WaveHeader));
	}

	~QPinAudio()
	{
	}

	HRESULT Init(
		QPinHost*    host,
		IBaseFilter* p)
	{
		QPinImpl<QPinAudio>::Init(host, p, L"Audio");

		return S_OK;
	}

	HRESULT FinalConstruct()
	{
		ATLTRACE("QPinAudio::FinalConstruct()\n");

		return S_OK;
	}

	void FinalRelease()
	{
		ATLTRACE("QPinAudio::FinalRelease()\n");
	}

	/* */

	void SetupAudioFormat(
		INT32 channels,
		INT32 samplingRate)
	{
		SetupMediaTypes(MTYPES);

		QMediaType* mt = MediaTypes();

		mt[MI_PCM].SetAudio(channels, samplingRate);
	}

	const WAVEFORMATEX* GetWaveHeader()
	{
		return &m_WaveHeader;
	}

	/* */

	HRESULT SetupAllocator(
		IMemAllocator*       alloc,
		const AM_MEDIA_TYPE* target)
	{
		HRESULT hRslt = CheckAccept(target);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		ALLOCATOR_PROPERTIES rprop = { 0 };
		ALLOCATOR_PROPERTIES aprop = { 0 };

		rprop.cBuffers = 20;
		rprop.cbBuffer = 2 * m_WaveHeader.nChannels * m_WaveHeader.nSamplesPerSec / 10;
		rprop.cbAlign  = 1;
		rprop.cbPrefix = 0;

		hRslt = alloc->SetProperties(
			&rprop,
			&aprop);
		if (FAILED(hRslt)) {
			return hRslt;
		}

		return S_OK;
	}

	HRESULT CheckAccept(
		const AM_MEDIA_TYPE* pmt)
	{
		if (pmt->majortype != MEDIATYPE_Audio) {
			return VFW_E_TYPE_NOT_ACCEPTED;
		}

		if (pmt->formattype == FORMAT_WaveFormatEx  &&
			pmt->cbFormat   >= sizeof(WAVEFORMATEX) &&
			pmt->pbFormat   != 0) {

			const WAVEFORMATEX* w = (const WAVEFORMATEX*)(pmt->pbFormat);

			ATLTRACE("Wave: %d ch %d Hz\n", w->nChannels, w->nSamplesPerSec);

			memcpy(&m_WaveHeader, w, sizeof(m_WaveHeader));

		} else {
			return VFW_E_TYPE_NOT_ACCEPTED;
		}

		return S_OK;
	}

	/* */

}; // QPinAudio

