package org.qrone.one;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

import javax.xml.transform.TransformerException;

import org.qrone.one.event.QrONEServiceListener;
import org.qrone.one.event.QrONEUserListener;
import org.w3c.dom.Document;

/**
 * T[o[ŉғT[rX̒ۃNXłB <BR>
 * <BR>
 * HttpServlet NXɂ悭ĂׁA擾eՂł傤BServlet lAQrONEServer 
 * N XMLSocket ʐMł̃T[o[TChASY͑SẴNXpNXō
 * Kv܂B̃NX́AT[rXɐڑĂSẴ[U[Ƃ̐ڑۂAS[U[
 * ւ̓o͎i񋟂܂B<BR>
 * 
 * <H3>ڍ׏</H3>
 * 
 * SẴT[rX̃CX^Xɂ ServiceNameAServiceDomainURIAServiceURI ̎O
 * ʎq蓖ĂĂ܂B<BR>
 * <BR>
 * ServiceName ̓T[rXNXƂɗ^鎯ʎqłBɑ΂AServiceURI ́ÃT[
 * rXۂɋNĂT[rX̃CX^XƂɗ^鎯ʎqłBقȂ ServiceURI
 * ɂ͕KقȂCX^X蓖Ă܂B<BR>
 * <BR>
 *  ServiceDomainURI@̓T[rXCX^XԂŃZbVIuWFNgĹׂAT[rX
 * CX^XԂɋʂ̃hCw肵܂B ServiceDomainURI T[rXCX^XԂ
 * ́A[U[ێZbVIuWFNgʂ̂̂ɂȂ܂B
 * 
 * @author J.Tabuchi
 * @since 2005/8/6
 * @version 1.0
 * @link QrONE Technology : http://www.qrone.org/
 */
public abstract class QrONEService{
	private QrONEServiceConfig config;
	private LinkedList userlist = new LinkedList();
	private Hashtable userToListenerMap = new Hashtable();

	public QrONEService(){}
	
	public String getInitParameter(String name){
		return config.getInitParameter(name);
	}
	public Enumeration getInitParameterNames(){
		return config.getInitParameterNames();
	}
	public QrONEServiceConfig getServiceConfig(){
		return config;
	}
	public QrONEServiceContext getServiceContext(){
		return config.getServiceContext();
	}
	public String getServiceName(){
		return config.getServiceName();
	}
	public void log(String msg){
		config.getServiceContext().log(msg);
	}
	public void log(String message, Throwable t){
		config.getServiceContext().log(message,t);
	}
	public void invalidate(){
		config.invalidate();
	}
	
	/**
	 * [U[̃T[rXɒǉ܂Bʏ펩IɃ[U[͒ǉ̂ł̃\bh
	 * ĂяoKv͂܂񂪁A[U[ڑvĂ ServiceURI ̃T[rX
	 * Oɂɐڑꍇɂ͌ĂяoKv܂B<BR>
	 * <BR>
	 * ŒǉĂяoꂽ[U[ <code>onRequest(QrONEUser, Document)</code> 
	 * ŔF؂Ɉڂ܂BႦ̃\bhĂяoĂ onRequest  true ԂȂ
	 * ̃T[rXɒǉ͂܂B̐ۂ͂̊֐̖߂lƂĂ̂܂ܕԂ܂B<BR>
	 * <BR>
	 * ̏ꍇAQrUser.getService() Ŏ擾łڑT[rX폜ƁAڑ
	 * ̂ؒfĂ܂߁A̐ڑT[rXSč폜Ă܂܂B
	 * 
	 * @param user@̃T[rXɒǉ郆[U[
	 * @param xmldoc@F؃hLg
	 * @return@ڑ
	 */
	public final boolean addUser(final QrONEUser user, Document xmldoc){
		if(onRequest(user,xmldoc)){
			userlist.add(user);
			
			QrONEUserListener listener = new QrONEUserListener(){
				public void onConnect(boolean success) {
					if(success)
						QrONEService.this.onConnect(user);
				}
				public void onClose() {
					QrONEService.this.onClose(user);
					for (Iterator iter = servicelistener.iterator(); iter.hasNext();) {
						((QrONEServiceListener) iter.next()).onLeft(user);
					}
					userlist.remove(user);
					userToListenerMap.remove(user);
				}
	
				public void onXML(Document xmldoc) {
					QrONEService.this.onXML(user, xmldoc);
				}
	
				public void onData(String xmlstr) {
					QrONEService.this.onData(user, xmlstr);
				}
				public void onUpdate(String sessionkey) {
					QrONEService.this.onUpdate(user,sessionkey);
				}
			};
			userToListenerMap.put(user,listener);
			user.addQrONEUserListener(listener);
			for (Iterator iter = servicelistener.iterator(); iter.hasNext();) {
				((QrONEServiceListener) iter.next()).onJoin(user);
			}
			return true;
		}
		return false;
	}
	
	/**
	 * [U[̃T[rX폜܂B̃T[rX[U[ڑĂT[rX
	 * łꍇɂ̓[U[Ƃ̐ڑؒf܂BłȂꍇɂ͒Pɂ̃T[rX
	 * ̂ݍ폜܂B
	 * 
	 * @param user@̃T[rX폜郆[U[
	 */
	public final void removeUser(QrONEUser user){
		if(user.getService() == this){
			user.close();
		}else if(userToListenerMap.containsKey(user)){
			userlist.remove(user);
			userToListenerMap.remove(user);
		}
	}
	
	/**
	 * ̃T[rXɐڑ̃[U[SĂ܂ޔzԂ܂B
	 * @return S[U[z
	 */
	public final QrONEUser[] getUsers(){
		return (QrONEUser[])userlist.toArray(new QrONEUser[userlist.size()]);
	}
	
	/**
	 * ^ꂽ[U[ɑ΂ xmlstr ŗ^ XML 𑗐M܂Bxmlstr ͕K
	 *  well-formed XML łȂ΂Ȃ܂B̃\bh <code>user.send(xmlstr)
	 *  </code> ƓłB
	 * @param user MΏۃ[U[
	 * @param xmlstr M well-formed XML
	 */
	public final void send(QrONEUser user, String xmlstr){
		user.send(xmlstr);
	}

	/**
	 * ^ꂽ[U[ɑ΂ xmldoc ŗ^ XML Document 𑗐M܂B̃\bh
	 * <code>user.send(xmldoc)</code> ƓłB
	 * @param user@MΏۃ[U[
	 * @param xmldoc M XML Document
	 */
	public final void send(QrONEUser user, Document xmldoc)throws TransformerException{
		user.send(xmldoc);
	}
	
	/**
	 * ڑ̑S[U[ɑ΂Ă xmlstr ŗ^ XML 𑗐M܂Bxmlstr ͕K
	 *  well-formed XML łȂ΂Ȃ܂B
	 * @param xmlstr@S[U[ɑM well-formed XML
	 */
	public final void sendAll(String xmlstr){
		for (Iterator iter = userlist.iterator(); iter.hasNext();) {
			((QrONEUser)iter.next()).send(xmlstr);
		}
	}

	/**
	 * ڑ̑S[U[ɑ΂Ă xmldoc ŗ^ XML Document 𑗐M܂B
	 * @param xmldoc@S[U[ɑM XML Document
	 */
	public final void sendAll(Document xmldoc) throws TransformerException{
		for (Iterator iter = userlist.iterator(); iter.hasNext();) {
			((QrONEUser)iter.next()).send(xmldoc);
		}
	}

	/**
	 * ́@user ڑ̑S[U[ɑ΂Ă xmlstr ŗ^ XML 𑗐M܂B
	 * xmlstr ͕K well-formed XML łȂ΂Ȃ܂B
	 * @param xmlstr@S[U[ɑM well-formed XML
	 */
	public final void sendAllExcept(QrONEUser user, String xmlstr){
		for (Iterator iter = userlist.iterator(); iter.hasNext();) {
			QrONEUser u = (QrONEUser)iter.next();
			if(u != user) u.send(xmlstr);
		}
	}

	/**
	 * ́@user ڑ̑S[U[ɑ΂Ă xmldoc ŗ^ XML Document 
	 * 𑗐M܂B
	 * @param xmldoc@S[U[ɑM XML Document
	 */
	public final void sendAllExcept(QrONEUser user, Document xmldoc)
	throws TransformerException{
		for (Iterator iter = userlist.iterator(); iter.hasNext();) {
			QrONEUser u = (QrONEUser)iter.next();
			if(u != user) u.send(xmldoc);
		}
	}
	/**
	 * ̃T[rX̋NɈxĂяo܂B֐̂߂ɗpӂꂽ\bhȂ̂
	 * I[o[Chꍇɂ <code>super.init(config)</code> ĂяoKv
	 * ܂B
	 */
	public void init(){
	}
	
	/**
	 * ̃T[rX̋NɈxĂяo܂BsׂɃI[o[Ch
	 * ꍇɂ͕K <code>super.init(config)</code> ĂяoĂB
	 * @param config Nݒ
	 */
	public void init(QrONEServiceConfig config){
		if(config!=null) return;
		this.config = config;
		for (Iterator iter = servicelistener.iterator(); iter.hasNext();) {
			((QrONEServiceListener) iter.next()).onInit();
		}
		init();
	}
	
	/**
	 * ̃T[rX̏IɈxĂяo܂BĨf[^Ȃǂ̃N[
	 * AbvsĂBI[o[Chꍇɂ͕K <code>super.destroy()</code> 
	 * ĂяoĂB
	 */
	public void destroy(){
		for (Iterator iter = servicelistener.iterator(); iter.hasNext();) {
			((QrONEServiceListener) iter.next()).onDestroy();
		}
	}
	
	/**
	 * ̃T[rXɐڑĂ悤ƂĂ郆[U[F؂܂B̃\bh true 
	 * ԂꍇÃ[U[͂̃T[rXɒǉ܂Afalse Ԃꍇɂ͂
	 * [U[͂̃T[rXɐڑł܂B
	 * <BR>
	 * ^ XML ̓[U[̃T[rXɐڑ邽߂̃NGXgő
	 * ĂF؃hLgłB DocumentElement ƂāA<code>&lt;QrONE
	 * uri="..." sid="..."&gt;...&lt;/QrONE&gt; </code>̂悤ȃ^O
	 * KAqm[h݂͑Ȃ\܂Auri y sid ͕Kw
	 * 肳Ă܂B
	 *  
	 * @param user@ڑvĂ郆[U[
	 * @param xmldoc@F؃hLg
	 * @return@
	 */
	public abstract boolean onRequest(QrONEUser user, Document xmldoc);
	
	/**
	 * [U[̃T[rXɒǉꂽɌĂяo܂B
	 * @param user@ǉꂽ[U[
	 */
	public abstract void onConnect(QrONEUser user);
	
	/**
	 * [U[̃T[rX폜钼OɌĂяo܂B
	 * @param user@폜郆[U[
	 */
	public abstract void onClose(QrONEUser user);
	
	/**
	 * [U[ XML f[^ĂÂ܂܂ XML ̐f[^Ԃ܂B
	 * Ăf[^s XML łꍇɂ̃\bh͌Ăяo܂B
	 * @param user@M[U[
	 * @param data@Mf[^
	 */
	public abstract void onData(QrONEUser user, String data);
	
	/**
	 * [U[ XML f[^ĂA XMLParser ɂ DOM
	 * IuWFNgԂ܂BXML  well-formed łȂ͂Ɏsꍇɂ͂̃\
	 * bh͌Ăяo܂B
	 * @param user@M[U[
	 * @param xmldoc MXML  DOM
	 */
	public abstract void onXML(QrONEUser user, Document xmldoc);

	/**
	 * [U[̃ZbVIuWFNg̍XVɌĂяo܂Bۂɂ
	 * <code>user.update()</code> ĂяoꂽɌĂяôŃZbV
	 * IuWFNg̍XVĎĂł͂܂B
	 * @param sessionkey 
	 * @param user@XV[U[
	 */
	public abstract void onUpdate(QrONEUser user, String sessionkey);
	
	
	//-----------------------------//
	// QrONEServiceListener

	private LinkedList servicelistener = new LinkedList();;

	/**
	 * Add QrONEServiceListener instance.
	 * @param listener eventhandler instance
	 */
	public void addQrONEServiceListener(QrONEServiceListener listener) {
		servicelistener.add(listener);
	}

	/**
	 * Remove QrONEServiceListener instance that is already added.
	 * @param listener eventhandler instance
	 */
	public void removeQrONEServiceListener(QrONEServiceListener listener) {
		servicelistener.remove(listener);
	}
}
