package org.qrone.one;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.servlet.ServletContext;

import org.apache.log4j.Logger;
import org.qrone.XMLTools;
import org.qrone.one.inner.DefaultSession;
import org.qrone.one.inner.QrONEAppDocument;
import org.qrone.one.inner.ServiceException;
import org.qrone.xmlsocket.XMLSocketNIO;
import org.qrone.xmlsocket.XMLSocketServerNIO;
import org.qrone.xmlsocket.event.XMLSocketServerListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/**
 * QrONE WebSocketServer.<BR>
 * <BR>
 * JavaScript ɂāAXMLSocket ʐM\ɂVXe̒ƂȂT[o[NX
 * łBۂ XMLSocket ʐM̃T[o[̏Lqɂ́AQrONEService 
 * NXpNXÃCX^XAServiceDomainURI yс@ServiceURI 
 * Ɋ֘AÂēo^邱Ƃŗp\ɂȂ܂B<br>
 * <br>
 * <b>Oo͂ɂ</b><br>
 * <br>
 * QrONEServer ǂ̂悤ȌoHŁAǂ̂悤ȒʐMǂ IP ƍsĂ̂m肽
 * ꍇɂ́Alog4j ̃vpeBt@CłAWEB-INF/classes/log4j.xml 
 * 邱Ƃł̏ڍׂOo͂Ƃē邱Ƃł܂B
 * 
 * @author J.Tabuchi
 * @since 2005/8/6
 * @version 1.0
 * @link QrONE Technology : http://www.qrone.org/
 */
public class QrONEServer{
	private static final Logger log = Logger.getLogger(QrONEServer.class);
	private static QrONEServer instance;
	/**
	 * QrONEServer ̃VOgCX^XԂ܂BT[o[NlX
	 * NXQƂƂɕ֗łB
	 * @return@VOgCX^X
	 */
	public static QrONEServer getInstance(){
		if(instance==null) instance = new QrONEServer();
		return instance;
	}

	public static final int MAJOR_VERSION	 = 1;
	public static final int MINOR_VERSION	 = 0;
	public static final String INFO = "QrONE - WebSocketServer Ver1.0";
	
	public static final int SERVER_CLOSED	 = 0;
	public static final int SERVER_STARTING	 = 1;
	public static final int SERVER_OPEN		 = 2;
	public static final int SERVER_CLOSING   = 3;
	
	private int SERVER_PORT	 = 9601;
	private int status = SERVER_CLOSED;
	
	private Vector appDocList = new Vector();
	private Hashtable uidToQrONEUsermap = new Hashtable();
	private Hashtable uriToQrONEServicemap = new Hashtable();
	private Hashtable sessionmap = new Hashtable();
	private Hashtable serviceToConfigmap = new Hashtable();
	
	private XMLSocketServerNIO socketServer;
	private ServletContext servletcontext;
	
	public QrONEServer(){
		log.debug("new QrONEServer();");
	}
	
	/**
	 * T[o[̏s܂B<code>open()</code>
	 * sOɕKĂяoȂ΂܂B
	 * @param context
	 * @throws SAXException
	 */
	public void init(ServletContext context) throws SAXException {
		this.servletcontext = context;
		appDocList.clear();
		File file = new File(servletcontext.getRealPath("/WEB-INF/service.xml"));
		if(file.exists()){
			Document doc = XMLTools.read(file);
			Element docElement = doc.getDocumentElement();
			if(docElement.getNodeName().equals("qrone-app")){
				appDocList.add(new QrONEAppDocument(this,doc,context));
				log.debug("loaded - /WEB-INF/service.xml");
			}
		}
		
		File dir = new File(servletcontext.getRealPath("/WEB-INF/services"));
		if(dir.exists()){
			File[] files = dir.listFiles();
			for (int i = 0; i < files.length; i++) {
				if(files[i].getName().endsWith(".xml")){
					Document doc = XMLTools.read(files[i]);
					Element docElement = doc.getDocumentElement();
					if(docElement.getNodeName().equals("qrone-app")){
						appDocList.add(new QrONEAppDocument(this,doc,context));
						log.debug("loaded - /WEB-INF/services/" + files[i].getName());
					}
				}
			}
		}
	}
	
	
	/**
	 * T[o[Jn܂B
	 * @throws IOException 
	 */
	public void open() throws IOException{
		socketServer = new XMLSocketServerNIO();
		socketServer.addXMLSocketServerListener(new XMLSocketServerListener(){
			public void onOpen(boolean success) {
				if(success){
					log.info("QrONEServer has started.");
					status = SERVER_OPEN;
				}else{
					status = SERVER_CLOSED;
				}
			}
			public void onClose() {
				log.info("QrONEServer has closed.");
				status = SERVER_CLOSED;
			}
			public void onClose(Exception e) {
				log.info("QrONEServer has closed. (with Exception)",e);
				status = SERVER_CLOSED;
			}
			public void onNewClient(XMLSocketNIO xmlsocket) {
				QrONEUser user = new QrONEUser(QrONEServer.this, xmlsocket);
				uidToQrONEUsermap.put(user.getUniqueId(),user);
				log.debug("onNewClient (UID:"+user.getUniqueId()+")");
			}
			public void onError(Exception e) {
			}
		});
		status = SERVER_STARTING;
		socketServer.open(SERVER_PORT);
	}
	
	/**
	 * T[o[I܂
	 */
	public void close(){
		status = SERVER_CLOSING;
		socketServer.close();
	}
	
	/**
	 * T[o[Ԃ擾܂
	 * @return T[o[
	 */
	public int getStatus(){
		return status;
	}
	
	/**
	 * ^ꂽ uid ɑΉ郆[U[Ԃ܂B
	 * @param uid
	 * @return [U[
	 */
	public QrONEUser getUser(String uid){
		return (QrONEUser)uidToQrONEUsermap.get(uid);
	}
	
	/**
	 * S[U[܂ނ̔zԂ܂B
	 * @return S[U[̔z
	 */
	public QrONEUser[] getUsers(){
		return (QrONEUser[])uriToQrONEServicemap.values().toArray(new QrONEUser[0]);
	}
	
	/**
	 * ^ꂽ ServiceURI ɑΉT[rXԂ܂BT[rX̃CX^X݂Ȃ
	 * ꍇɂ͂쐬ĕԂ܂B
	 * @param uri@T[rXURI
	 * @return T[rXCX^X
	 * @throws ServiceException T[rX쐬G[
	 */
	public QrONEService getService(String uri) throws ServiceException{
		QrONEService service = (QrONEService)uriToQrONEServicemap.get(uri);
		if(service == null){
			for (Iterator iter = appDocList.iterator(); iter.hasNext();) {
				QrONEAppDocument appdoc = (QrONEAppDocument) iter.next();
				QrONEServiceConfig config = appdoc.createService(uri);
				
				if(config!=null){
					serviceToConfigmap.put(config.getService(),config);
					uriToQrONEServicemap.put(uri,config.getService());
					config.getService().init(config);
					return config.getService();
				}
			}
			throw new ServiceException("NoSuchService",null);
		}else{
			return service;
		}
	}
	
	/**
	 * p̃T[rX폜܂B
	 */
	public void removeService(QrONEService service){
		serviceToConfigmap.remove(service);
		service.destroy();
	}
	
	public QrONEServiceConfig getServiceConfig(QrONEService service){
		return (QrONEServiceConfig)serviceToConfigmap.get(service);
	}
	
	public QrONEServiceContext getServiceContext(String urlpath){
		for (Iterator iter = appDocList.iterator(); iter.hasNext();) {
			QrONEAppDocument appdoc = (QrONEAppDocument) iter.next();
			if(appdoc.getServiceMappingByUri(urlpath)!=null){
				return appdoc.getServiceContext();
			}
		}
		return null;
	}
	
	
	/**
	 * T[rXɊ֘AÂĂ ServiceURI ̃XgԂ܂B
	 * @return 蓖ăT[rXURĨXg
	 */
	public String[] getServiceURIs(){
		return (String[])uriToQrONEServicemap.keySet().toArray(new String[0]);
	}
	
	/**
	 * ZbVIuWFNg擾܂BZbV݂Ȃꍇɂ͍쐬܂B
	 * @param user@Ώۃ[U[
	 * @return@ZbVIuWFNg
	 */
	public QrONESession getSession(QrONEUser user){
		QrONESession session = getSession(user,false);
		if(session == null){
			session = getSession(user,true);
		}
		return session;
	}
	
	/**
	 * ZbVIuWFNg擾܂B@create == true ̏ꍇɂ͕KVKɃZbV쐬
	 * ܂B create == false ̏ꍇɂ͊̃ZbVIuWFNgꍇɂ͂Ԃ
	 * ݂Ȃꍇɂ null Ԃ܂B
	 * @param user@Ώۃ[U[
	 * @param create@ZbVVKɍ쐬邩ǂ
	 * @return ZbVIuWFNg
	 */
	public QrONESession getSession(QrONEUser user, boolean create){
		String sessionDomainId = user.getSessionId() 
			+ "::" + getServiceConfig(user.getService()).getServiceDomainURI();
	
		if(create){
			DefaultSession session = new DefaultSession(sessionDomainId,this);
			session.joinUser(user);
			sessionmap.put(sessionDomainId,session);
			return session;
		}else{
			DefaultSession session = (DefaultSession)sessionmap.get(sessionDomainId);
			if(session!=null) session.joinUser(user);
			return session;
		}
	}
	
	/**
	 * Ώۂ̃ZbV폜܂
	 * @param session@폜ZbV
	 */
	public void removeSession(QrONESession session){
		sessionmap.remove(session.getId());
	}
}
