package org.qrone.one;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.*;

import org.apache.log4j.Logger;

/**
 * QrONEServer ւ XML-Servlet ̓C^[tF[XłB<BR>
 * <BR>
 * JavaScript  HTTPPostRequest 󂯕tAXMLSocket T[o[ւ̓͂Ƃ
 * Ԃ܂B܂ŏɐڑZbV̊ms܂B
 * 
 * @author J.Tabuchi
 * @since 2005/8/6
 * @version 1.0
 * @link QrONE Technology : http://www.qrone.org/
 */
public class QrONEHttpGateway extends HttpServlet{
	private static final Logger log = Logger.getLogger(QrONEHttpGateway.class);
	private static final long serialVersionUID = 1L;

	public void doPost(HttpServletRequest req, HttpServletResponse resp){
		try{
			req.setCharacterEncoding("UTF-8");
			
			String[] uidstrs = req.getParameterValues("uid");
			String uid=null;
			if(uidstrs != null && uidstrs.length>0){
				uid = uidstrs[0];
			}else{
				return;
			}
	
			StringBuffer xmlstr = new StringBuffer();
			String buf = "";
			BufferedReader reader = req.getReader();
			while(buf != null){
				xmlstr.append(buf);
				buf = reader.readLine();
			}
			
			log.debug("HTTP POST " + req.getRemoteAddr() 
					+ " UID:" + uid
					+ " CONTENT:" + xmlstr.toString());
			
			QrONEUser user = null;
			user = QrONEServer.getInstance().getUser(uid);
			if(user != null){
				user.onData(xmlstr.toString());
			}
			
			resp.setContentType("text/xml");
			PrintWriter out = resp.getWriter();
			String xml;
			if(user != null){
				if(!user.isOnline()){
					xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
						+ "<QrONE error=\"NoSuchService\" desc=\"the requested service not available\"/>";
				}else{
					xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
						+ "<QrONE info=\"success\"/>";
				}
			}else{
				xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
						+"<QrONE error=\"UserNotFound\" desc=\"there is no user at uid : "
						+uid+"\"/>";
			}
			out.println(xml);
			log.debug("HTTP RESPONSE " +xml);
			out.close();
		}catch(IOException e){
			log.debug("ERROR",e);
		}
	} 
}
