/*
 * Decompiled with CFR 0.152.
 */
package org.qrone.xmlsocket.nio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import org.qrone.xmlsocket.nio.ExceptionListener;
import org.qrone.xmlsocket.nio.ProtocolDecoder;
import org.qrone.xmlsocket.nio.ProtocolEncoder;
import org.qrone.xmlsocket.nio.SelectorThread;

public abstract class SelectorSocket
implements ExceptionListener {
    private SelectorThread thread;
    private SocketChannel channel;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;
    private LinkedList sendqueue = new LinkedList();
    private ByteArrayOutputStream buf;
    private ProtocolEncoder encoder;
    private ProtocolDecoder decoder;

    public SelectorSocket(SelectorThread thread, ProtocolEncoder encoder, ProtocolDecoder decoder) {
        this.thread = thread;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public void connect(String address, int port) throws IOException {
        this.connect(new InetSocketAddress(address, port));
    }

    public void connect(SocketAddress address) throws IOException {
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        this.channel.connect(address);
        this.thread.register(this.channel, 8, this);
    }

    public void connect(SocketChannel channel) {
        try {
            this.channel = channel;
            channel.socket().setReceiveBufferSize(1024);
            channel.socket().setSendBufferSize(1024);
            this.inBuffer = ByteBuffer.allocateDirect(channel.socket().getReceiveBufferSize());
            this.thread.register(channel, 1, this);
        }
        catch (IOException e) {
            this.close();
            this.onError(e);
        }
    }

    public void read() {
        try {
            int readBytes = this.channel.read(this.inBuffer);
            if (readBytes == -1) {
                this.close();
                return;
            }
            if (readBytes == 0) {
                return;
            }
            this.inBuffer.flip();
            byte[] packet = this.decoder.decode(this.inBuffer);
            while (packet != null) {
                this.onPacket(packet);
                packet = this.decoder.decode(this.inBuffer);
            }
            this.inBuffer.clear();
        }
        catch (IOException e) {
            this.close();
            this.onError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        try {
            LinkedList linkedList;
            if (this.outBuffer == null) {
                linkedList = this.sendqueue;
                synchronized (linkedList) {
                    if (this.sendqueue.size() > 0) {
                        this.outBuffer = (ByteBuffer)this.sendqueue.remove(0);
                    }
                }
            }
            this.channel.write(this.outBuffer);
            if (this.outBuffer.hasRemaining()) {
                return true;
            }
            this.outBuffer = null;
            linkedList = this.sendqueue;
            synchronized (linkedList) {
                block12: {
                    if (this.sendqueue.size() <= 0) break block12;
                    return true;
                }
            }
        }
        catch (IOException e) {
            this.close();
            this.onError(e);
        }
        return false;
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] packet) {
        LinkedList linkedList = this.sendqueue;
        synchronized (linkedList) {
            this.sendqueue.add(this.encoder.encode(packet));
        }
        this.thread.requestWrite(this.channel);
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.onClose();
    }

    public abstract void onConnect(boolean var1);

    public abstract void onClose();

    public abstract void onTimeout();

    public abstract void onPacket(byte[] var1);

    public abstract void onError(Exception var1);
}

