/*
 * Decompiled with CFR 0.152.
 */
package org.qrone.xmlsocket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.qrone.xmlsocket.nio.ExceptionListener;
import org.qrone.xmlsocket.nio.SelectorSocket;
import org.qrone.xmlsocket.nio.SelectorThread;

public abstract class SelectorServerSocket
implements ExceptionListener {
    protected SelectorThread thread;
    protected ServerSocketChannel serverchannel;

    public SelectorServerSocket(SelectorThread thread) {
        this.thread = thread;
    }

    public void open(int port) {
        try {
            this.serverchannel = ServerSocketChannel.open();
            InetSocketAddress isa = new InetSocketAddress(port);
            this.serverchannel.socket().bind(isa, 100);
            this.thread.register(this.serverchannel, 16, this);
            this.onOpen(true);
        }
        catch (IOException e) {
            this.onOpen(false);
            this.onError(e);
        }
    }

    public void close() {
        try {
            this.serverchannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.onClose();
    }

    public void accept() {
        try {
            SocketChannel channel = this.serverchannel.accept();
            if (channel != null) {
                SelectorSocket socket = this.createSelectorSocket();
                socket.connect(channel);
                this.onNewClient(socket);
                socket.onConnect(true);
            }
        }
        catch (IOException e) {
            this.close();
            this.onError(e);
        }
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverchannel;
    }

    public abstract SelectorSocket createSelectorSocket();

    public abstract void onOpen(boolean var1);

    public abstract void onClose();

    public abstract void onNewClient(SelectorSocket var1);

    public abstract void onError(Exception var1);
}

