/*
 * Decompiled with CFR 0.152.
 */
package org.qrone.xmlsocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.qrone.XMLTools;
import org.qrone.xmlsocket.event.XMLSocketListener;
import org.qrone.xmlsocket.inner.XMLSocketProtocolDecoder;
import org.qrone.xmlsocket.inner.XMLSocketProtocolEncoder;
import org.qrone.xmlsocket.nio.ExceptionListener;
import org.qrone.xmlsocket.nio.SelectorSocket;
import org.qrone.xmlsocket.nio.SelectorThread;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLSocketNIO
extends SelectorSocket {
    private static final Logger log;
    private boolean parsexml = true;
    private LinkedList xmllistener = new LinkedList();
    private Charset inputcs = Charset.forName("UTF-8");
    private Charset outputcs = Charset.forName("UTF-8");
    private String ipaddress = "";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.qrone.xmlsocket.XMLSocketNIO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public XMLSocketNIO() throws IOException {
        this(new SelectorThread(new ExceptionListener(){

            public void onError(Exception e) {
                this.onError(e);
            }
        }));
    }

    public XMLSocketNIO(SelectorThread thread) {
        super(thread, new XMLSocketProtocolEncoder(), new XMLSocketProtocolDecoder());
    }

    public void setEncoding(Charset cs) {
        this.setEncoding(cs, cs);
    }

    public void setEncoding(String charset) {
        this.setEncoding(Charset.forName(charset));
    }

    public void setEncoding(Charset input, Charset output) {
        this.inputcs = input;
        this.outputcs = output;
    }

    public void send(String str) {
        try {
            this.send(str.getBytes(this.outputcs.displayName()));
            log.debug((Object)("SEND " + this.ipaddress + " " + str));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void send(Document doc) throws TransformerException {
        Transformer t = XMLTools.transformerFactory.newTransformer();
        t.setOutputProperty("encoding", this.outputcs.displayName());
        String str = XMLTools.write((Node)doc, t);
        try {
            this.send(str.getBytes(this.outputcs.displayName()));
            log.debug((Object)("SEND " + this.ipaddress + " " + str));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setXMLParsing(boolean bool) {
        this.parsexml = bool;
    }

    public Socket getSocket() {
        return this.getSocketChannel().socket();
    }

    public void onConnect(boolean success) {
        this.ipaddress = this.getSocket().getInetAddress().getHostAddress();
        Iterator iter = this.xmllistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketListener)iter.next()).onConnect(success);
        }
        if (success) {
            log.debug((Object)("CONNECT " + this.ipaddress));
        }
    }

    public void onClose() {
        Iterator iter = this.xmllistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketListener)iter.next()).onClose();
        }
        log.debug((Object)("CLOSE " + this.ipaddress));
    }

    public void onError(Exception e) {
        Iterator iter = this.xmllistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketListener)iter.next()).onError(e);
        }
        log.debug((Object)("ERROR " + this.ipaddress), (Throwable)e);
    }

    public void onTimeout() {
        Iterator iter = this.xmllistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketListener)iter.next()).onTimeout();
        }
        log.debug((Object)("TIMEOUT " + this.ipaddress));
    }

    public void onPacket(byte[] b) {
        try {
            this.onData(new String(b, this.inputcs.displayName()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void onData(String data) {
        Iterator iter = this.xmllistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketListener)iter.next()).onData(data);
        }
        log.debug((Object)("DATA " + this.ipaddress + data));
        try {
            this.onXML(XMLTools.read(data));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void onXML(Document doc) {
        Iterator iter = this.xmllistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketListener)iter.next()).onXML(doc);
        }
    }

    public void addXMLSocketListener(XMLSocketListener listener) {
        this.xmllistener.add(listener);
    }

    public void removeXMLSocketListener(XMLSocketListener listener) {
        this.xmllistener.remove(listener);
    }
}

