/*
 * Decompiled with CFR 0.152.
 */
package org.qrone;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;

public class XMLTools {
    public static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    public static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    private XMLTools() {
    }

    public static Document read(URL xmlurl) throws SAXException {
        try {
            HttpURLConnection httpc = (HttpURLConnection)xmlurl.openConnection();
            InputStream in = httpc.getInputStream();
            return XMLTools.read(in);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXIOException(e);
        }
        catch (IOException e) {
            throw new SAXIOException(e);
        }
    }

    public static Document read(String xmldata) throws SAXException {
        return XMLTools.read(new InputSource(new StringReader(xmldata)));
    }

    public static Document read(String xmldata, String encode) throws SAXException {
        try {
            return XMLTools.read(new ByteArrayInputStream(xmldata.getBytes(encode)));
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXIOException(e);
        }
    }

    public static Document read(Reader reader) throws SAXException {
        return XMLTools.read(new InputSource(reader));
    }

    public static Document read(InputStream in) throws SAXException {
        try {
            return builderFactory.newDocumentBuilder().parse(in);
        }
        catch (IOException e) {
            throw new SAXIOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SAXIOException(e);
        }
    }

    public static Document read(InputSource source) throws SAXException {
        try {
            return builderFactory.newDocumentBuilder().parse(source);
        }
        catch (IOException e) {
            throw new SAXIOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SAXIOException(e);
        }
    }

    public static Document read(File xmlfile) throws SAXException {
        try {
            return builderFactory.newDocumentBuilder().parse(xmlfile);
        }
        catch (FileNotFoundException e) {
            throw new SAXIOException(e);
        }
        catch (IOException e) {
            throw new SAXIOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SAXIOException(e);
        }
    }

    public static void xsltransform(Node xmlnode, URL stylesheetUrl, Writer out) throws TransformerException {
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheetUrl.toExternalForm()));
        transformer.transform(new DOMSource(xmlnode), new StreamResult(out));
    }

    public static void xsltransform(Node xmlnode, URL stylesheetUrl, OutputStream out) throws TransformerException {
        XMLTools.xsltransform(xmlnode, stylesheetUrl, new OutputStreamWriter(out));
    }

    public static void xsltransform(Node xmlnode, URL stylesheetUrl, File out) throws TransformerException {
        try {
            XMLTools.xsltransform(xmlnode, stylesheetUrl, new FileOutputStream(out));
        }
        catch (FileNotFoundException e) {
            throw new TransformerIOException(e);
        }
    }

    public static String xsltransform(Node xmlnode, URL stylesheetUrl) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        XMLTools.xsltransform(xmlnode, stylesheetUrl, stringWriter);
        return stringWriter.getBuffer().toString();
    }

    public static void write(Node xmlnode, Transformer transformer, Writer writer) throws TransformerException {
        try {
            SAXResult saxresult = new SAXResult(new XMLContentHandler(transformer, writer));
            DOMSource domsource = new DOMSource(xmlnode);
            transformer.transform(domsource, saxresult);
        }
        catch (IOException e) {
            throw new TransformerIOException(e);
        }
    }

    public static void write(Node xmlnode, Writer writer) throws TransformerException {
        Transformer transformer = transformerFactory.newTransformer();
        if (xmlnode instanceof Document) {
            transformer.setOutputProperty("omit-xml-declaration", "no");
        } else {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        XMLTools.write(xmlnode, transformer, writer);
    }

    public static void write(Node xmlnode, OutputStream out) throws TransformerException {
        XMLTools.write(xmlnode, new OutputStreamWriter(out));
    }

    public static void write(Node xmlnode, File out) throws TransformerException {
        try {
            XMLTools.write(xmlnode, new FileOutputStream(out));
        }
        catch (FileNotFoundException e) {
            throw new TransformerIOException(e);
        }
    }

    public static String write(Node xmlnode, Transformer transformer) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        XMLTools.write(xmlnode, transformer, stringWriter);
        return stringWriter.getBuffer().toString();
    }

    public static String write(Node xmlnode) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        XMLTools.write(xmlnode, stringWriter);
        return stringWriter.getBuffer().toString();
    }

    public static NodeList getElementsById(Element e, String id) {
        final LinkedList l = new LinkedList();
        XMLTools.getElementsByIdImpl(e, id, l);
        return new NodeList(){

            public Node item(int index) {
                return (Node)l.get(index);
            }

            public int getLength() {
                return l.size();
            }
        };
    }

    private static void getElementsByIdImpl(Element e, String id, LinkedList l) {
        if (e.getAttribute("id").equals(id)) {
            l.add(e);
        }
        NodeList nodelist = e.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            if (node instanceof Element) {
                XMLTools.getElementsByIdImpl((Element)node, id, l);
            }
            ++i;
        }
    }

    public static Element getElementById(Element e, String id) {
        if (e.getAttribute("id").equals(id)) {
            return e;
        }
        NodeList nodelist = e.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Element r;
            Node node = nodelist.item(i);
            if (node instanceof Element && (r = XMLTools.getElementById((Element)node, id)) != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public static void removeChildAll(Element e) {
        while (e.hasChildNodes()) {
            e.removeChild(e.getFirstChild());
        }
    }

    public static String getTextContent(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                StringBuffer buf = new StringBuffer("");
                XMLTools.getTextContentImpl(buf, node);
                return buf.toString();
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        return null;
    }

    private static void getTextContentImpl(StringBuffer buf, Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                NodeList list = node.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    buf.append(XMLTools.getTextContent(list.item(i)));
                    ++i;
                }
                break;
            }
            case 3: 
            case 4: {
                if (node.getNodeValue() == null) break;
                buf.append(node.getNodeValue());
            }
        }
    }

    public static Element find(Node xmlnode, String nodename) {
        return XMLTools.find(xmlnode, nodename, 0);
    }

    public static Element find(Node xmlnode, String nodename, int index) {
        NodeList nodelist = xmlnode.getChildNodes();
        int cnt = 0;
        while (cnt < nodelist.getLength()) {
            Node node = nodelist.item(cnt);
            if (node.getNodeName().equals(nodename) && node instanceof Element) {
                if (index == 0) {
                    return (Element)node;
                }
                --index;
            }
            ++cnt;
        }
        return null;
    }

    public static Element find(Node xmlnode, String nodename, String attrName, String attrValue) {
        return XMLTools.find(xmlnode, nodename, attrName, attrValue, 0);
    }

    public static Element find(Node xmlnode, String nodename, String attrName, String attrValue, int index) {
        NodeList nodelist = xmlnode.getChildNodes();
        int cnt = 0;
        while (cnt < nodelist.getLength()) {
            Node node = nodelist.item(cnt);
            if (node.getNodeName().equals(nodename) && node instanceof Element && XMLTools.hasAttr((Element)node, attrName, attrValue)) {
                if (index == 0) {
                    return (Element)node;
                }
                --index;
            }
            ++cnt;
        }
        return null;
    }

    public static String[] getAttrInherits(Node node, String attrName) {
        NodeList nodelist = XMLTools.getAttrInheritNodeList(node, attrName);
        String[] strs = new String[nodelist.getLength()];
        int i = 0;
        while (i < strs.length) {
            strs[i] = nodelist.item(i).getNodeValue();
            ++i;
        }
        return strs;
    }

    public static NodeList getAttrInheritNodeList(Node node, String attrName) {
        final Node enode = node;
        final String ename = attrName;
        return new NodeList(){
            private List nodelist;

            private List getNodeList() {
                if (this.nodelist == null) {
                    this.nodelist = XMLTools.getAttrInheritList(enode, ename);
                }
                return this.nodelist;
            }

            public Node item(int arg0) {
                return (Node)this.getNodeList().get(arg0);
            }

            public int getLength() {
                return this.getNodeList().size();
            }
        };
    }

    public static Node[] getAttrInheritArray(Node node, String attrName) {
        List list = XMLTools.getAttrInheritList(node, attrName);
        Node[] nodes = new Node[list.size()];
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = (Node)list.get(i);
            ++i;
        }
        return nodes;
    }

    public static List getAttrInheritList(Node node, String attrName) {
        Vector<Node> nodelist = new Vector<Node>();
        Node parent = node;
        while (parent != null) {
            Node attr;
            NamedNodeMap map = parent.getAttributes();
            if (map != null && (attr = map.getNamedItem(attrName)) != null) {
                nodelist.add(attr);
            }
            parent = parent.getParentNode();
        }
        return nodelist;
    }

    public static NodeList filter(Node xmlnode, String nodename) {
        final NodeList nodelist = xmlnode.getChildNodes();
        int cLength = 0;
        final int[] changes = new int[nodelist.getLength()];
        Arrays.fill(changes, -1);
        int cnt = 0;
        while (cnt < nodelist.getLength()) {
            Node node = nodelist.item(cnt);
            if (node.getNodeName().equals(nodename)) {
                changes[cLength] = cnt;
                ++cLength;
            }
            ++cnt;
        }
        final int changeLength = cLength;
        return new NodeList(){

            public int getLength() {
                return changeLength;
            }

            public Node item(int index) {
                return nodelist.item(changes[index]);
            }
        };
    }

    public static NodeList filter(NodeList xmlnodelist, String nodename) {
        NodeList nodelist = xmlnodelist;
        final int[] lengths = new int[nodelist.getLength()];
        final NodeList[] changes = new NodeList[nodelist.getLength()];
        int buf = 0;
        int cnt = 0;
        while (cnt < nodelist.getLength()) {
            changes[cnt] = XMLTools.filter(nodelist.item(cnt), nodename);
            buf += changes[cnt].getLength();
            lengths[cnt] = changes[cnt].getLength();
            ++cnt;
        }
        final int changeLength = buf;
        return new NodeList(){

            public int getLength() {
                return changeLength;
            }

            public Node item(int index) {
                int cnt = 0;
                while (cnt < lengths.length) {
                    if (index < lengths[cnt]) {
                        return changes[cnt].item(index);
                    }
                    index -= lengths[cnt];
                    ++cnt;
                }
                return null;
            }
        };
    }

    public static NodeList filter(Node xmlnode, String nodename, String attrName, String attrValue) {
        final NodeList nodelist = xmlnode.getChildNodes();
        int cLength = 0;
        final int[] changes = new int[nodelist.getLength()];
        Arrays.fill(changes, -1);
        int cnt = 0;
        while (cnt < nodelist.getLength()) {
            Node node = nodelist.item(cnt);
            if (node.getNodeName().equals(nodename) && node instanceof Element && XMLTools.hasAttr((Element)node, attrName, attrValue)) {
                changes[cLength] = cnt;
                ++cLength;
            }
            ++cnt;
        }
        final int changeLength = cLength;
        return new NodeList(){

            public int getLength() {
                return changeLength;
            }

            public Node item(int index) {
                return nodelist.item(changes[index]);
            }
        };
    }

    public static NodeList filter(NodeList xmlnodelist, String nodename, String attrName, String attrValue) {
        NodeList nodelist = xmlnodelist;
        final int[] lengths = new int[nodelist.getLength()];
        final NodeList[] changes = new NodeList[nodelist.getLength()];
        int buf = 0;
        int cnt = 0;
        while (cnt < nodelist.getLength()) {
            changes[cnt] = XMLTools.filter(nodelist.item(cnt), nodename, attrName, attrValue);
            buf += changes[cnt].getLength();
            lengths[cnt] = changes[cnt].getLength();
            ++cnt;
        }
        final int changeLength = buf;
        return new NodeList(){

            public int getLength() {
                return changeLength;
            }

            public Node item(int index) {
                int cnt = 0;
                while (cnt < lengths.length) {
                    if (index < lengths[cnt]) {
                        return changes[cnt].item(index);
                    }
                    index -= lengths[cnt];
                    ++cnt;
                }
                return null;
            }
        };
    }

    public static boolean hasAttr(Node xmlnode, String attrName) {
        NamedNodeMap nodeMap = xmlnode.getAttributes();
        if (nodeMap != null) {
            int cnt = 0;
            while (cnt < nodeMap.getLength()) {
                if (nodeMap.item(cnt).getNodeName().equals(attrName)) {
                    return true;
                }
                ++cnt;
            }
        }
        return false;
    }

    public static boolean hasAttr(Node xmlnode, String attrName, String attrValue) {
        NamedNodeMap nodeMap = xmlnode.getAttributes();
        if (nodeMap != null) {
            int cnt = 0;
            while (cnt < nodeMap.getLength()) {
                if (nodeMap.item(cnt).getNodeName().equals(attrName) && nodeMap.item(cnt).getNodeValue().equals(attrValue)) {
                    return true;
                }
                ++cnt;
            }
        }
        return false;
    }

    public static String encodeXMLText(String text) {
        char[] ch = text.toCharArray();
        StringBuffer buf = new StringBuffer();
        boolean last = false;
        int i = 0;
        while (i < ch.length) {
            switch (ch[i]) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\'': {
                    buf.append("&#39;");
                    break;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsi:USERINFO  xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\" yjh=\"&lt;&gt;kk\"><ID>klonoa&lt;&gt;@kids5.com</ID>\n<NAME>\u30c6\u30b9\u30c8</NAME>\n</xsi:USERINFO>";
        Document doc = null;
        try {
            doc = XMLTools.read(content);
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        Element element = doc.getDocumentElement();
        System.err.println("TN:" + element.getTagName());
        NodeList nodelist = element.getElementsByTagName("*");
        nodelist = nodelist.item(0).getChildNodes();
        int cnt = 0;
        while (cnt < nodelist.getLength()) {
            Node node = nodelist.item(cnt);
            System.err.println("NN:" + node.getNodeName());
            System.err.println("NV:" + node.getNodeValue());
            ++cnt;
        }
        String out = null;
        try {
            out = XMLTools.write(doc);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        System.err.println(out);
        try {
            doc = XMLTools.read(content);
        }
        catch (SAXException e2) {
            e2.printStackTrace();
        }
        element = doc.getDocumentElement();
        System.err.println("TN:" + element.getTagName());
        nodelist = element.getElementsByTagName("*");
        nodelist = nodelist.item(0).getChildNodes();
        int cnt2 = 0;
        while (cnt2 < nodelist.getLength()) {
            Node node = nodelist.item(cnt2);
            System.err.println("NN:" + node.getNodeName());
            System.err.println("NV:" + node.getNodeValue());
            ++cnt2;
        }
        System.err.println("");
    }

    public static class SAXIOException
    extends SAXException {
        private static final long serialVersionUID = -2723450640126637708L;

        public SAXIOException(Exception e) {
            super(e);
        }
    }

    public static class TransformerIOException
    extends TransformerException {
        private static final long serialVersionUID = -3650189568709899317L;

        public TransformerIOException(Exception e) {
            super(e);
        }
    }

    public static class XMLContentHandler
    implements ContentHandler {
        private Transformer transformer;
        private Writer writer;
        private int level;
        private boolean indent = false;
        private boolean declaration = true;
        private String version = "1.0";
        private String encoding = "UTF-8";

        public XMLContentHandler(Transformer transformer, Writer writer) throws IOException {
            this.writer = new BufferedWriter(writer);
            this.transformer = transformer;
        }

        public void startDocument() throws SAXException {
            this.level = 0;
            if (!this.transformer.getOutputProperty("method").toLowerCase().equals("xml")) {
                throw new SAXNotSupportedException();
            }
            if (this.transformer.getOutputProperty("indent").toLowerCase().equals("yes")) {
                this.indent = true;
            }
            if (this.transformer.getOutputProperty("omit-xml-declaration").toLowerCase().equals("yes")) {
                this.declaration = false;
            } else {
                String enc = this.transformer.getOutputProperty("encoding");
                if (enc != null && !enc.equals("")) {
                    this.encoding = enc;
                }
                String ver = this.transformer.getOutputProperty("version");
                if (enc != null && !enc.equals("")) {
                    this.version = ver;
                }
                try {
                    this.writer.write("<?xml version=\"" + this.version + "\" encoding=\"" + this.encoding + "\"?>\n");
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }

        public void endDocument() throws SAXException {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                this.writer.write("<" + qName);
                int count = 0;
                while (count < attributes.getLength()) {
                    this.writer.write(" " + attributes.getQName(count) + "=\"" + XMLTools.encodeXMLText(attributes.getValue(count)) + "\"");
                    ++count;
                }
                this.writer.write(">");
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            ++this.level;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            --this.level;
            try {
                this.writer.write("</" + qName + ">");
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                String data = new String(ch, start, length);
                this.writer.write(XMLTools.encodeXMLText(data));
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

