package org.qrone.xmlsocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;

import org.apache.log4j.Logger;
import org.qrone.xmlsocket.event.XMLSocketServerListener;
import org.qrone.xmlsocket.nio.SelectorServerSocket;
import org.qrone.xmlsocket.nio.SelectorSocket;
import org.qrone.xmlsocket.nio.SelectorThread;

public class XMLSocketServerNIO extends SelectorServerSocket{
	private static final Logger log = Logger.getLogger(XMLSocketServerNIO.class);
	
	public XMLSocketServerNIO() throws IOException {
		super(new SelectorThread());
	}
	public XMLSocketServerNIO(SelectorThread thread) {
		super(thread);
	}

	private static final int SERVER_TIMEOUT = 30000;
	private LinkedList serverlistener = new LinkedList();

	private Charset inputcs  = Charset.forName("UTF-8");
	private Charset outputcs = Charset.forName("UTF-8");
	
	public void setEncoding(Charset cs){
		setEncoding(cs,cs);
	}
	
	public void setEncoding(String charset){
		setEncoding(Charset.forName(charset));
	}
	
	public void setEncoding(Charset input, Charset output){
		inputcs = input;
		outputcs = output;
	}
	
	/**
	 * XMLSocketServer@T[o[Ɋ֘AÂĂ ServerSocket CX^XԂ܂B
	 * @return p̃T[o[\Pbg
	 */
	public ServerSocket getServerSocket(){
		return serverchannel.socket();
	}
	
	/**
	 * T[o[JnɌĂяo܂B success == false ̎ɂ
	 * <b>T[o[JnĂ܂B</b><BR>
	 * pNXł̃\bhI[o[ChƃCxgnh̃CxgĂ΂ȂȂ܂B<BR>
	 * <BR>
	 * ʏ addXMLSocketServerListener(XMLSocketServerListener) 
	 * ŃCxgnh𗘗pĂB
	 * @see #addXMLSocketServerListener(XMLSocketServerListener)
	 * @param success T[o[Jn
	 */
	public void onOpen(boolean success){
 		for (Iterator iter = serverlistener.iterator(); iter.hasNext();) {
			((XMLSocketServerListener)iter.next()).onOpen(success);
		}
 		if(success) log.debug("OPEN");
	}

	/**
	 * G[ɌĂяo܂B<BR>
	 * pNXł̃\bhI[o[ChƃCxgnh̃CxgĂ΂ȂȂ܂B<BR>
	 * <BR>
	 * ʏ addXMLSocketServerListener(XMLSocketServerListener) 
	 * ŃCxgnh𗘗pĂB
	 * @see #addXMLSocketServerListener(XMLSocketServerListener)
	 * @param e G[
	 */
	public void onError(Exception e) {
 		for (Iterator iter = serverlistener.iterator(); iter.hasNext();) {
			((XMLSocketServerListener)iter.next()).onError(e);
		}
 		log.debug("ERROR");
	}

	/**
	 * T[o[IɌĂяo܂B<BR>
	 * pNXł̃\bhI[o[ChƃCxgnh̃CxgĂ΂ȂȂ܂B<BR>
	 * <BR>
	 * ʏ addXMLSocketServerListener(XMLSocketServerListener) 
	 * ŃCxgnh𗘗pĂB
	 * @see #addXMLSocketServerListener(XMLSocketServerListener)
	 */
	public void onClose(){
 		for (Iterator iter = serverlistener.iterator(); iter.hasNext();) {
			((XMLSocketServerListener)iter.next()).onClose();
		}
 		log.debug("CLOSE");
	}

	/**
	 * V Macromedia Flash  .swf t@C XMLSocket ʐMvꂽ
	 * ĂяoAswf t@CƒʐMm钼O XMLSocket IuWFNgn܂B<BR>
	 * pNXł̃\bhI[o[ChƃCxgnh̃CxgĂ΂ȂȂ܂B<BR>
	 * <BR>
	 * ʏ addXMLSocketServerListener(XMLSocketServerListener) 
	 * ŃCxgnh𗘗pĂB
	 * @see #addXMLSocketServerListener(XMLSocketServerListener)
	 */
	public void onNewClient(XMLSocketNIO socket){
 		for (Iterator iter = serverlistener.iterator(); iter.hasNext();) {
			((XMLSocketServerListener)iter.next()).onNewClient(socket);
		}
 		log.debug("NEWCLIENT " 
 				+ socket.getSocket().getInetAddress().getHostAddress());
	}
	
	public void onNewClient(SelectorSocket socket) {
		onNewClient((XMLSocketNIO)socket);
	}
	
	/**
	 * Cxgnho^ĊeCxg擾܂B
	 * @param listener@Cxgnh
	 */
	public void addXMLSocketServerListener(XMLSocketServerListener listener) {
		serverlistener.add(listener);
	}

	/**
	 * o^ĂCxgnh폜܂B
	 * @param listener@Cxgnh
	 */
	public void removeXMLSocketServerListener(XMLSocketServerListener listener) {
		serverlistener.remove(listener);
	}

	public SelectorSocket createSelectorSocket() {
		XMLSocketNIO socket = new XMLSocketNIO(thread);
		socket.setEncoding(inputcs,outputcs);
		return socket;
	}
}
