/*!
  \example connectById.cpp
  \brief VA ID pڑTv

  \author Satofumi KAMIMURA

  $Id: connectById.cpp 1194 2009-07-31 13:45:24Z satofumi $
*/

#include "UrgCtrl.h"
#include "UrgUtils.h"
#include "Connection.h"
#include "ConnectionUtils.h"
#include <iostream>

using namespace qrk;
using namespace std;


namespace
{
  bool adjustById(UrgCtrl urg[], long serials[], size_t n)
  {
    // VA ID m
    vector<long> device_serials;
    for (size_t i = 0; i < n; ++i) {
      long serial_id = urgSerialId<UrgCtrl>(&urg[i]);
      device_serials.push_back(serial_id);
    }

    // URG IuWFNg VA ID Ŏw肵ԂɂȂ悤ɂ
    for (size_t i = 0; i < n; ++i) {
      long requested_serial = serials[i];
      if (device_serials[i] == requested_serial) {
        continue;
      }

      // ڕW ID CfbNXTČ
      vector<long>::iterator p =
        find(device_serials.begin(), device_serials.end(), requested_serial);
      if (p == device_serials.end()) {
        return false;
      }
      size_t swap_index = p - device_serials.begin();

      swapConnection<UrgCtrl>(urg[i], urg[swap_index]);
      swap(device_serials[i], device_serials[swap_index]);
    }

    return true;
  }
}


int main(int argc, char *argv[])
{
  // ڑ URG  VA ID ԂɋLq
  long serials[] = {
    710002,
    614967,
  };
  const char* devices[] = { "/dev/ttyACM0", "/dev/ttyACM1" };

  // URG IuWFNg̏
  UrgCtrl urg[2];

  // ڑ
  size_t n = sizeof(serials) / sizeof(serials[0]);
  for (size_t i = 0; i < n; ++i) {
    if (! urg[i].connect(devices[i])) {
      cout << "UrgCtrl::connect: " << urg[i].what() << endl;
      exit(1);
    }
  }

  // w肵 VA ID ƃIuWFNgv悤ɒ
  if (! adjustById(urg, serials, n)) {
    cout << "fail swapById()" << endl;
    exit(1);
  }

  // ʂ\
  cout << "result" << endl;
  for (size_t i = 0; i < n; ++i) {
    cout << i << ", " << urgSerialId<UrgCtrl>(&urg[i]) << endl;
  }

  // !!!

  for (size_t i = 0; i < n; ++i) {
    delete urg[i].connection();
    urg[i].setConnection(NULL);
  }

#ifdef MSC
  getchar();
#endif

  return 0;
}
