/*!
  \example multi_urg.c

  \brief  URG păf[^擾sTv

  Q URG pāAꂼ̑Of[^\

  \author Satofumi KAMIMURA

  $Id: multi_urg.c 1194 2009-07-31 13:45:24Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


//! main
int main(int argc, char *argv[])
{
  enum {
    Times = 10,
    Urgs = 2,
  };

  urg_t urg[Urgs];
  long *data[Urgs];
  int data_max[Urgs];
  int timestamp;
  int ret;
  int n;
  int i;
  int k;

  const char *devices[] = { "COM3", "COM4" }; /* Windows p */
  //const char *devices[] = { "/dev/ttyACM0", "/dev/ttyACM1" }; /* Linux p */

  /* ڑ */
  for (i = 0; i < Urgs; ++i) {
    ret = urg_connect(&urg[i], devices[i], 115200);
    if (ret < 0) {
      urg_exit(&urg[i], "urg_connect()");
    }
    /*  MD R}h̃NAp */
    urg_laserOff(&urg[i]);

    /* f[^ԈƁAA]eՂɂȂ */
    /* Ԉw肪 2 ƁAf[^]ʂ͔ɂȂ */
    //urg_setSkipLines(&urg[i], 2);

    /* Mobt@̊m */
    data_max[i] = urg_dataMax(&urg[i]);
    data[i] = (long*)malloc(sizeof(long) * data_max[i]);
    if (data[i] == NULL) {
      perror("data buffer");
      exit(1);
    }
  }

  /* MD ł̃f[^v */
  for (i = 0; i < Urgs; ++i) {
    urg_setCaptureTimes(&urg[i], Times);

    /* f[^v */
    ret = urg_requestData(&urg[i], URG_MD, URG_FIRST, URG_LAST);
    if (ret < 0) {
      urg_exit(&urg[i], "urg_requestData()");
    }
  }

  for (k = 0; k < Times; ++k) {
    for (i = 0; i < Urgs; ++i) {
      /* f[^擾ĂAI */
      int remain_times = urg_remainCaptureTimes(&urg[i]);
      printf("    %d: ", i);
      printf("(%03d/%03d): ", remain_times, Times);
      if (remain_times <= 0) {
        printf("\n");
        continue;
      }

      /* M */
      n = urg_receiveData(&urg[i], data[i], data_max[i]);
      if (n < 0) {
        // ɎMł邩Ȃ̂ŁA𑱂
        printf("%s: %s\n", "urg_receiveData()", urg_error(urg));

      } else {

        /* \ */
        timestamp = urg_recentTimestamp(&urg[i]);
        printf("timestamp: %d, ", timestamp);
#if 0
        {
          int j;
          for (j = 0; j < n; ++j) {
            /* urg_minDistance() ȉ̋f[^́Al\ */
            printf("%d:%ld, ", j, data[i][j]);
          }
          printf("\n");
        }
#endif
        printf("\n");
      }
    }
  }

  /* ؒf */
  for (i = 0; i < Urgs; ++i) {
    urg_disconnect(&urg[i]);
    free(data[i]);
  }

#ifdef MSC
  getchar();
#endif

  return 0;
}
