#ifndef QRK_URG_CTRL_H
#define QRK_URG_CTRL_H

/*!
  \file
  \brief URG ZT

  \author Satofumi KAMIMURA

  $Id: UrgCtrl.h 1300 2009-09-15 06:36:54Z satofumi $
*/

#include "RangeSensor.h"
#include "Coordinate.h"


namespace qrk
{
  class Connection;


  /*!
    \brief URG ZT
  */
  class UrgCtrl : public Coordinate, public RangeSensor
  {
    UrgCtrl(const UrgCtrl& rhs);
    UrgCtrl& operator = (const UrgCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  protected:
    virtual void captureReceived(void);

  public:
    /*!
      \brief IvVpp[^
    */
    enum {
      DefaultBaudrate = 115200, //!< ڑ̃ftHg{[[g
      DefaultRetryTimes = 3,    //!< ʐMs̃gC
      Infinity = 0,             //!< ̃f[^擾

      Off = 0,                  //!< [U Off p
      On = 1,                   //!< [U On p
    };

    UrgCtrl(void);
    virtual ~UrgCtrl(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void setConnection(Connection* con);
    Connection* connection(void);
    void disconnect(void);
    bool isConnected(void) const;

    long minDistance(void) const;
    long maxDistance(void) const;
    int maxScanLines(void) const;


    /*!
      \brief ʐMs̃gC񐔂ݒ

      ʐMɎsƂ̃gC񐔂w肷BɉԂꂽꍇAgC񐔂̓ZbgBŐݒ肷郊gC񐔂́AMƎMŋʂƂȂB

      \param[in] times gC

      \attention #AutoCapture ̂Ƃ̂ݗL
    */
    void setRetryTimes(size_t times);


    /*!
      \brief ŕۑXLf[^ݒ

      #AutoCapture, #IntensityCapture ̊e[hł́AUrgCtrl NXŃXLf[^ێĂB̃\bhł́ÃXLf[^̕ێwłB

      \param[in] size XLf[^̕ێ
    */
    void setCapturesSize(size_t size);


    /*!
      \brief PXLɂ鎞

      \return PXLɂ鎞 [msec]
    */
    int scanMsec(void) const;


    /*!
      \brief f[^擾[h̎w

      \param[in] mode #RangeCaptureMode Œ`Ă郂[hwłB

      \see captureMode()
    */
    void setCaptureMode(RangeCaptureMode mode);


    /*!
      \brief f[^擾[h

      \return ݂̃f[^擾[h

      \see setCaptureMode()
    */
    RangeCaptureMode captureMode(void);


    /*!
      \brief f[^擾͈͂̎w

      \ref scip_capture_parameter_section QƂ̂

      \param[in] begin_index Jnʒu
      \param[in] end_index Iʒu
    */
    void setCaptureRange(int begin_index, int end_index);


    /*!
      \brief XLf[^̎擾Ԋu

      f[^擾px邱ƂɂAURG ƃCuԂ̃f[^ʐMʂłB\n
      \ref scip_capture_parameter_section QƂ̂

      \param[in] interval ɂP񂾂f[^擾邩
    */
    void setCaptureFrameInterval(size_t interval);


    /*!
      \brief f[^擾񐔂̎w

      \ref scip_capture_parameter_section QƂ̂

      \param[in] times f[^擾

      \attention f[^擾[h #AutoCapture, #IntensityCapture ̂Ƃ̂ݗL
    */
    void setCaptureTimes(size_t times);


    /*!
      \brief cf[^擾񐔂̎擾

      \return cf[^擾

      \attention f[^擾[h #AutoCapture, #IntensityCapture ̂Ƃ̂ݗL
    */
    size_t remainCaptureTimes(void);


    /*!
      \brief 擾f[^̃O[vݒ

      ̎擾f[^Pɂ܂Ƃ߁A擾f[^ʂB

      \param[in] skip_lines Pɂ܂Ƃ߂擾f[^

      Ⴆ΁A܂Ƃ߂擾f[^P̂Ƃ̃f[^
      \verbatim
100, 101, 103, 104, 105, 100, ... \endverbatim

      ̏ꍇA܂Ƃ߂擾f[^QɂƁA擾f[^
      \verbatim
100, 103, 100, ... \endverbatim

      ƂȂB(ԒZf[^Ԃ)\n
      ɂAURG ƃCuԂ̃f[^ʐMʂłB

      AURG ƃCuԂ̒ʐMf[^͌邪 capture() Ԃf[^ʂ͕ωA
      \verbatim
100, 100, 103, 103, 100, 100, ... \endverbatim

      ԂB\n
      f[^ʂωȂ̂ rad2index(), index2rad() ̓ۏ؂邽߁B
    */
    void setCaptureSkipLines(size_t skip_lines);


    int capture(std::vector<long>& data, long* timestamp = NULL);


#if defined(USE_INTENSITY)
    /*
      \brief xf[^Ƌf[^̎擾

      \attention Top-URG, Classic-URG ̂ݑΉ (2008-12-24 )
    */
    int captureWithIntensity(std::vector<long>& data,
                             std::vector<long>& intensity_data,
                             long* timestamp = NULL);
#endif


    /*!
      \brief f[^擾̒f

      \attention f[^擾[h #AutoCapture, #IntensityCapture ̂Ƃ̂ݗL
    */
    void stop(void);


    bool setTimestamp(int timestamp = 0, int* response_msec = NULL,
                      int* force_delay_msec = NULL);

    long recentTimestamp(void) const;


    /*!
      \brief [U̓_/

      \param[in] on true œ_ / false ŏ
    */
    bool setLaserOutput(bool on);

    double index2rad(const int index) const;
    int rad2index(const double radian) const;

    void setParameter(const RangeSensorParameter& parameter);
    RangeSensorParameter parameter(void) const;


    /*!
      \brief URG p[^̍ēǂݍ

      \retval true 
      \retval false G[
    */
    bool loadParameter(void);


    /*!
      \brief o[W̎擾

      \param[out] lines o[W̊i[

      \retval true 
      \retval false G[

      <b>Example</b>
      - \ref viewVvSample.cpp
    */
    bool versionLines(std::vector<std::string>& lines);

    bool reset(void);
  };
}

#endif /* !QRK_URG_CTRL_H */
