#ifndef QRK_C_SCIP_HANDLER_H
#define QRK_C_SCIP_HANDLER_H

/*!
  \file
  \brief SCIP R}h

  \author Satofumi KAMIMURA

  $Id: scip_handler.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "urg_parameter_t.h"
#include "serial_t.h"


enum {
  ScipNoWaitReply = 0,       /*!< SCIP ҂Ȃ */
  ScipWaitReply = 1,          /*!< ҂ */

  ScipLineWidth = 64 + 1 + 1,  /*!< Ps̍ő咷 */
};


/*!
  \brief R}hM

  \param[out] serial VA̍\
  \param[in] send_command MR}h

  \retval 0 
  \retval < 0 G[
*/
extern int scip_send(serial_t *serial, const char *send_command);


/*!
  \brief R}hM

  ret  NULL łȂꍇAR}h̉Ɋi[B܂Aexpected_ret ɂ́AƂ݂ȂĂ悢R}hAI[ -1 ̔zŒ`łBR}h expected_ret Ɋ܂܂ꍇÅ֐̖߂l̓[()ƂȂB\n
  expected_ret ݂̂́Ȁ݂Ԃɐݒ肷悤ɃR}hwꍇɁAR}hƂĂ̓[ȊOԂĂ܂̂AƂ݂Ȃ߁B

  \param[out] serial VA̍\
  \param[out] return_code ߂l
  \param[in] expected_ret Ƃ݂Ȃ߂l
  \param[in] timeout ^CAEg [msec]

  \retval 0 
  \retval < 0 G[
*/
extern int scip_recv(serial_t *serial, const char *command_first,
                     int* return_code, int expected_ret[],
                     int timeout);


/*!
  \brief SCIP2.0 [hւ̑J

  SCIP2.0 [hɑJڂꍇA[()ԂB

  \param[in,out] serial VA̍\

  \retval 0 
  \retval < 0 G[
*/
extern int scip_scip20(serial_t *serial);


/*!
  \brief [ȔA̒f

  MD ~߂ړIŎgꍇɂ́A҂Ȃ@ QT ssAQT ̉ urg_receiveData() ŏ邱ƁB

  \param[in,out] serial VA̍\
  \param[in] return_code QT R}h̉
  \param[in] wait_reply ҂ȂƂ ScipNoWaitReply / ҂Ƃ ScipWaitReply

  \retval 0 
  \retval < 0 G[
*/
extern int scip_qt(serial_t *serial, int *return_code, int wait_reply);


/*!
  \brief p[^̎擾

  \param[in,out] serial VA̍\
  \param[out] parameters urg_parameter_t \̃o

  \retval 0 
  \retval < 0 G[

*/
extern int scip_pp(serial_t *serial, urg_parameter_t *parameters);


/*!
  \brief o[W̎擾

  \param[in,out] serial VA̍\
  \param[out] lines o[W̊i[
  \param[in] lines_max ̍ő吔

  \retval 0 
  \retval < 0 G[
*/
extern int scip_vv(serial_t *serial, char *lines[], int lines_max);


/*!
  \brief {[[g̕ύX

  \param[in,out] serial VA̍\
  \param[in] baudrate {[[g

  \retval 0 
  \retval < 0 G[
*/
extern int scip_ss(serial_t *serial, long baudrate);

#endif /* !QRK_C_SCIP_HANDLER_H */
