/*!
  \example captureIntensitySample.cpp

  \brief xf[^̎擾Tv

  \author Satofumi KAMIMURA

  $Id: captureIntensitySample.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "UrgCtrl.h"
#include "delay.h"
#include <cstdlib>
#include <cstdio>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }
  int scan_msec = urg.scanMsec();
  urg.setCaptureMode(IntensityCapture);

  enum {
    CaptureTimes = 10,
  };

  vector<long> data;
  vector<long> intensity_data;

  for (int i = 0; i < CaptureTimes; ++i) {
    long timestamp = 0;

    // xtf[^̎擾
    int data_n = urg.captureWithIntensity(data, intensity_data, &timestamp);

    if (data_n > 0) {
      int front_index = urg.rad2index(0.0);

      // \
      // urg_minDistance() ȉ̋f[^́Al\
      printf("%d: %ld [mm] (%ld), %ld [msec]\n",
             i, data[front_index], intensity_data[front_index], timestamp);
    }
    delay(scan_msec);
  }

#ifdef MSC
  getchar();
#endif

  return 0;
}
