/*!
  \file
  \brief j^Ή DifferentialDrive NX

  \author Satofumi KAMIMURA

  $Id: mDifferentialDrive.cpp 1219 2009-08-14 02:59:46Z satofumi $
*/

#include "mDifferentialDrive.h"
#include "DifferentialDrive.h"
#include "DeviceManager.h"
#include "ExecutionType.h"
#include "TcpipSocket.h"

using namespace qrk;
using namespace std;


struct mDifferentialDrive::pImpl
{
  DifferentialDrive run_;
  ExecutionType::Type type_;
  Connection* created_connection_;


  pImpl(void)
    : type_(ExecutionType::object()->type()), created_connection_(NULL)
  {
    if (type_ == ExecutionType::Simulation) {
      created_connection_ = new TcpipSocket;
      run_.setConnection(created_connection_);
    }
  }


  ~pImpl(void)
  {
    delete created_connection_;
  }
};


mDifferentialDrive::mDifferentialDrive(void) : pimpl(new pImpl)
{
}


mDifferentialDrive::~mDifferentialDrive(void)
{
}


const char* mDifferentialDrive::what(void) const
{
  return pimpl->run_.what();
}


bool mDifferentialDrive::connect(const char* device, long baudrate)
{
  DeviceManager device_manager;
  long port;

  switch (pimpl->type_) {
  case ExecutionType::Simulation:
    // |[gԍ擾ATCP/IP ƂĐڑ
    port = device_manager.port(device);
    return pimpl->run_.connect("localhost", port);
    break;

  case ExecutionType::RealDevice:
  case ExecutionType::Recording:
    // w肳ꂽfoCXɃVAƂĐڑ
    return pimpl->run_.connect(device, baudrate);
    break;

  case ExecutionType::Playback:
    // !!! ڑȂ
    // !!! L^ĂʂǂݏoĕԂ
    // !!!
    return false;
    break;
  }

  return false;
}


void mDifferentialDrive::disconnect(void)
{
  // !!!
}


bool mDifferentialDrive::isConnected(void) const
{
  // !!!

  return false;
}


void mDifferentialDrive::setConnection(Connection* connection)
{
  (void)connection;

  // !!!
}


Connection* mDifferentialDrive::connection(void)
{
  // !!!

  return NULL;
}


void mDifferentialDrive::followLine(const Position<long>& line,
                                    const Coordinate* coordinate)
{
  // !!! sR}hOɕ\
  // !!! sR}hʂɕ`悷

  pimpl->run_.followLine(line, coordinate);
}


void mDifferentialDrive::stopLine(const Position<long>& line,
                                  const Coordinate* coordinate)
{
  (void)line;
  (void)coordinate;

  // !!!
}


void mDifferentialDrive::followCircle(const Point<long>& center, long radius,
                                      const Coordinate* coordinate)
{
  // !!! sR}hOɕ\
  // !!! sR}hʂɕ`悷

  pimpl->run_.followCircle(center, radius, coordinate);
}


void mDifferentialDrive::stopCircle(const Point<long>& center,
                                    long radius, const Angle& angle,
                                    const Coordinate* coordinate)
{
  (void)center;
  (void)radius;
  (void)angle;
  (void)coordinate;

  // !!!
}


void mDifferentialDrive::spin(const Angle& angle_per_sec)
{
  // !!! sR}hOɕ\

  pimpl->run_.spin(angle_per_sec);
}


void mDifferentialDrive::rotate(const Angle& angle,
                                const Coordinate* coordinate)
{
  // !!! sR}hOɕ\
  // !!! sR}hʂɕ`悷

  pimpl->run_.rotate(angle, coordinate);
}


void mDifferentialDrive::stop(void)
{
  // !!! sR}hOɕ\
  // !!! sR}hʂɕ`悷

  pimpl->run_.stop();
}


Position<long> mDifferentialDrive::position(Coordinate* coordinate) const
{
  return pimpl->run_.position(coordinate);
}


long mDifferentialDrive::straightVelocity(void) const
{
  // !!!

  return 0;
}


Angle mDifferentialDrive::rotateVelocity(void) const
{
  // !!!

  return deg(0);
}


void mDifferentialDrive::setRobotPosition(const Position<long>& position,
                                          const Coordinate* coordinate)
{
  (void)position;
  (void)coordinate;

  // !!!
}


void mDifferentialDrive::setStraightVelocity(long mm_per_sec)
{
  (void)mm_per_sec;

  // !!!
}


void mDifferentialDrive::setRotateVelocity(const Angle& angle_per_sec)
{
  (void)angle_per_sec;

  // !!!
}


void mDifferentialDrive::setStraightAcceleration(long mm_per_sec2)
{
  (void)mm_per_sec2;

  // !!!
}


void mDifferentialDrive::setRotateAcceleration(const Angle& angle_per_sec2)
{
  (void)angle_per_sec2;

  // !!!
}


bool mDifferentialDrive::isStable(void) const
{
  // !!!

  return false;
}


void mDifferentialDrive::setWheelVelocity(int id, long mm_per_sec)
{
  // !!! sR}hOɕ\

  pimpl->run_.setWheelVelocity(id, mm_per_sec);
}


string mDifferentialDrive::currentCommand(void) const
{
  // !!!

  return "Not implemented.";
}


void mDifferentialDrive::saveCommand(void)
{
  // !!!
}


void mDifferentialDrive::restoreCommand(void)
{
  // !!!
}


void mDifferentialDrive::commitParameters(void)
{
  // !!!
}


void mDifferentialDrive::setMotorParameter(int id, const motor_t& motor)
{
  (void)id;
  (void)motor;

  // !!!
}


void mDifferentialDrive::setEncoderParameter(int id, const encoder_t& encoder)
{
  (void)id;
  (void)encoder;

  // !!!
}


void mDifferentialDrive::setWheelParameter(int id, const wheel_t& wheel)
{
  (void)id;
  (void)wheel;

  // !!!
}


void mDifferentialDrive::setBodyParameter(const body_t& body)
{
  (void)body;

  // !!!
}
