/*!
  \file
  \brief ҋ@

  \author Satofumi KAMIMURA

  $Id: delay.cpp 1175 2009-07-22 22:26:13Z satofumi $
*/

#include "delay.h"
#include "system_delay.h"
#include "ExecutionType.h"
#include "EventScheduler.h"
#include "Lock.h"

using namespace qrk;


void qrk::delay(int msec)
{
  static EventScheduler event_scheduler_;
  static ExecutionType::Type type = ExecutionType::object()->type();

  if (type == ExecutionType::Simulation) {
    ConditionVariable condition;
    if (event_scheduler_.registerDelayEvent(&condition, msec)) {
      Lock mutex;
      mutex.lock();
      // !!! ł̑ҋ@ɃXbhI
      // !!! "QWaitCondition: mutex destroy failure." 
      // !!! Ώ@͕sBۗ
      condition.wait(&mutex);
    } else {
      // ̕ɓ̂́AEventScheduler ̃Xbh~ĂƂ
      fprintf(stderr, "delay: thread stopped.\n");
      system_delay(1000);
    }

  } else {
    system_delay(msec);
  }
}
