/*!
  \file
  \brief V~[ṼC֐sp

  \author Satofumi KAMIMURA

  $Id: SimulationMain.cpp 1235 2009-08-21 07:59:16Z satofumi $
*/

#include "SimulationMain.h"
#include "fileExist.h"
#include "luabindInit.h"
#include "luabindSimulator.h"
#include "luabindObstacles.h"
#include "luabindGeometry.h"
#include "luabindSystem.h"
#include "LuaHandler.h"
#include "log_printf.h"

using namespace qrk;
using namespace std;


struct SimulationMain::pImpl
{
  EventScheduler event_scheduler_;
  MainFunction* function_;
  int argc_;
  char **argv_;


  pImpl(MainFunction* function, int argc, char *argv[])
    : function_(function), argc_(argc), argv_(argv)
  {
  }


  void loadDevicePort(const char* file = "")
  {
    string setting_file = file;
    if (setting_file.empty()) {
      // JgEfBNgA~/.qrkrc T
      const string search_path[] = {
        "./simulation_settings.lua",
        "~/.qrkrc/simulation_settings.lua",
      };

      size_t n = sizeof(search_path) / sizeof(search_path[0]);
      size_t i;
      for (i = 0; i < n; ++i) {
        string path = search_path[i];

        // !!! p̊֐ɂׂ
        if (path[0] == '~') {
          const char* home_path = getenv("HOME");
          if (home_path) {
            path.replace(0, 1, home_path);
          }
        }

        if (fileExist(path.c_str())) {
          setting_file = path;
          break;
        }
      }
      if (i == n) {
        log_printf("no simulation_settings.lua file.\n");
        return;
      }
    }

    lua_State* L = luabindInit(LuaHandler::newthread(LuaHandler::pointer()));
    luabindSystem(L);
    luabindGeometry(L);
    luabindSimulator(L);
    luabindObstacles(L);
    LuaHandler::dofile(L, setting_file.c_str());
  }
};


SimulationMain::SimulationMain(MainFunction* function, int argc, char *argv[])
  : pimpl(new pImpl(function, argc, argv))
{
}


SimulationMain::~SimulationMain(void)
{
}


void SimulationMain::run(void)
{
  // foCXւ̃|[gȔ
  // !!! vOs̈Ńt@Cw肳Ă
  // !!! g悤ɂ
  pimpl->loadDevicePort();

  // CxgEXPW[̓Jn
  event_scheduler_.start();

  // w肳ꂽ֐Ăяo
  pimpl->function_(pimpl->argc_, pimpl->argv_);

  // !!! GUI ̃OER\[ɏoׂ͂
  event_scheduler_.terminate();
  fprintf(stderr, "simulation end.\n");
}
