#ifndef QRK_MODEL_MANAGER_H
#define QRK_MODEL_MANAGER_H

/*!
  \file
  \brief f̊Ǘ

  \author Satofumi KAMIMURA

  $Id: ModelManager.h 1181 2009-07-25 03:54:39Z satofumi $
*/

#include "Color.h"
#include <ode/ode.h>
#include <set>


namespace qrk
{
  class ModelManager
  {
    ModelManager(const ModelManager& rhs);
    ModelManager& operator = (const ModelManager& rhs);

    struct pImpl;
    pImpl* pimpl;

  public:
    typedef enum {
      Box,
      Cylinder,
      Sphere,
    } BodyType;

    typedef struct {
      BodyType type;
      dBodyID body_id;
      dReal length[3];
      Color color;
      bool obstacle;
    } model_t;

    typedef std::set<const model_t*> Models;

    ModelManager(void);
    ~ModelManager(void);

    void addBox(model_t* model, const dReal length[]);
    void addCylinder(model_t* model, dReal radius, dReal length);
    void addSphere(model_t* model, dReal radius);
    void remove(const model_t* model);

    bool obstacle(dBodyID id) const;

    const Models models(void) const;
  };
}

#endif /* !QRK_MODEL_MANAGER_H */
