/*!
  \file
  \brief DifferentialDrive ̃V~[^

  \author Satofumi KAMIMURA

  $Id: DifferentialDrive_device.cpp 1194 2009-07-31 13:45:24Z satofumi $
*/

#include "DifferentialDrive_device.h"
#include "BeegoModel.h"
#include "DeviceManager.h"
#include "robot_control.h"
#include "packet_handler.h"
#include "serial_connection.h"
#include "log_printf.h"

using namespace qrk;
using namespace std;

extern void encoder_setModel(BeegoModel* model);
extern void motor_setModel(BeegoModel* model);


struct DifferentialDrive_device::pImpl
{
  robot_t robot_;
  BeegoModel beego_model_;


  pImpl(const char* device)
  {
    DeviceManager device_manager;
    for (int i = 0; i < PortRetryMax; ++i) {
      long try_port = device_manager.nextPort();
      if (serial_setPort(try_port)) {
        device_manager.registerDevicePort(device, try_port);
        packet_initialize(&robot_);
        encoder_setModel(&beego_model_);
        motor_setModel(&beego_model_);
        return;
      }
    }

    log_printf("DifferentialDrive_device(): fail assign port.\n");
    throw;
  }
};


DifferentialDrive_device::DifferentialDrive_device(const char* device)
  : pimpl(new pImpl(device))
{
}


DifferentialDrive_device::~DifferentialDrive_device(void)
{
}


void DifferentialDrive_device::setParameter(const char* type,
                                            const char* parameter)
{
  (void)type;
  (void)parameter;

  // !!!
}


void DifferentialDrive_device::activate(void)
{
  pimpl->beego_model_.activate();
  robot_initialize(&pimpl->robot_);
}


void DifferentialDrive_device::execute(void)
{
  robot_update();
  packet_update();

  //Position<long> position = pimpl->beego_model_.position();
  //fprintf(stderr, "(%d, %d, %d)\n", position.x, position.y, position.deg());
}


size_t DifferentialDrive_device::nextExecuteInterval(void) const
{
  return 1;
}


void DifferentialDrive_device::setPosition(const qrk::Position<long>& position,
                                           OdeModel* model, bool fixed)
{
  pimpl->beego_model_.setPosition(position, model, fixed);
}


Position<long> DifferentialDrive_device::position(void) const
{
  return pimpl->beego_model_.position();
}


dBodyID DifferentialDrive_device::objectId(void) const
{
  return pimpl->beego_model_.objectId();
}
