#ifndef QRK_DEVICE_MANAGER_H
#define QRK_DEVICE_MANAGER_H

/*!
  \file
  \brief foCXǗ

  \author Satofumi KAMIMURA

  $Id: DeviceManager.h 1235 2009-08-21 07:59:16Z satofumi $
*/

#include <luabind/luabind.hpp>


namespace qrk
{
  class Device;
  class OdeModel;


  class DeviceManager
  {
    DeviceManager(const DeviceManager& rhs);
    DeviceManager& operator = (const DeviceManager& rhs);

    struct pImpl;
    pImpl* pimpl;

  public:
    DeviceManager(void);
    ~DeviceManager(void);

    void terminate(void);

    long nextPort(void);
    void registerDevicePort(const char* device, long port);
    long port(const char* device) const;


    void createDevice(const char* device_name, const char* class_name,
                      const char* alias);
    void createEvent(const luabind::object& function, const char* alias);
    void removeEvent(const char* alias);

    void setType(const char* type, const char* parameter);

    Device* device(const char* alias);
    OdeModel* model(const char* alias);
  };
}

#endif /* !QRK_DEVICE_MANAGER_H */
