#ifndef QRK_CAMERA_VIEW_MANAGER_H
#define QRK_CAMERA_VIEW_MANAGER_H

/*!
  \file
  \brief J_̐NX

  \author Satofumi KAMIMURA

  $Id: CameraViewManager.h 1235 2009-08-21 07:59:16Z satofumi $
*/

namespace qrk
{
  class Angle;


  class CameraViewManager
  {
    CameraViewManager(const CameraViewManager& rhs);
    CameraViewManager& operator = (const CameraViewManager& rhs);

    struct pImpl;
    pImpl* pimpl;

  public:
    CameraViewManager(void);
    ~CameraViewManager(void);

    bool updated(void) const;

    void setInitialView(double x, double y, double z,
                        const Angle& x_axis,
                        const Angle& y_axis,
                        const Angle& z_axis);
    void initializeView(void);

    void setBaseView(double x, double y, double z,
                     const Angle& x_axis,
                     const Angle& y_axis,
                     const Angle& z_axis);

    void setView(double x, double y, double z,
                 const Angle& x_axis, const Angle& y_axis, const Angle& z_axis);
    void view(double& x, double& y, double& z,
              Angle& x_axis, Angle& y_axis, Angle& z_axis);
    void setScale(double zoom);
    double scale(void) const;
  };
}

#endif /* !QRK_CAMERA_VIEW_MANAGER_H */
