/*!
  \file
  \brief ꎞ~\ȃ^C}[

  \author Satofumi KAMIMURA

  $Id: StopWatch.cpp 1053 2009-06-20 22:52:51Z satofumi $
*/

#include "StopWatch.h"
#include "ticks.h"

using namespace qrk;


struct StopWatch::pImpl
{
  enum {
    InvalidTicks = -1,
  };

  int start_ticks_;
  int pause_ticks_;


  pImpl(void)
  {
    initialize();
  }


  void initialize(void)
  {
    start_ticks_ = InvalidTicks;
    pause_ticks_ = InvalidTicks;
  }
};


StopWatch::StopWatch(void) : pimpl(new pImpl)
{
}


StopWatch::~StopWatch(void)
{
}


void StopWatch::start(void)
{
  if (pimpl->pause_ticks_ != pImpl::InvalidTicks) {
    // ꎞ~̏ꍇAĊJ
    resume();
    return;

  } else if (pimpl->start_ticks_ != pImpl::InvalidTicks) {
    // Đ̏ꍇ́A߂
    return;

  } else {
    // ~̏ꍇ́AJn
    pimpl->start_ticks_ = qrk::ticks();
  }
}


void StopWatch::stop(void)
{
  pimpl->initialize();
}


void StopWatch::pause(void)
{
  if ((pimpl->pause_ticks_ != pImpl::InvalidTicks) ||
      (pimpl->start_ticks_ == pImpl::InvalidTicks)) {
    // ꎞ~A~̏ꍇA߂
    return;
  }

  pimpl->pause_ticks_ = qrk::ticks();
}


void StopWatch::resume(void)
{
  // ꎞ~łȂ΁A߂
  if (pimpl->pause_ticks_ == pImpl::InvalidTicks) {
    return;
  }

  int paused_msec = qrk::ticks() - pimpl->pause_ticks_;
  pimpl->start_ticks_ += paused_msec;
  pimpl->pause_ticks_ = pImpl::InvalidTicks;
}


int StopWatch::ticks(void)
{
  if (pimpl->start_ticks_ == pImpl::InvalidTicks) {
    // ~
    return 0;

  } else if (pimpl->pause_ticks_ != pImpl::InvalidTicks) {
    // ꎞ~
    int now_ticks = qrk::ticks();

    return ((now_ticks - pimpl->start_ticks_)
            - (now_ticks - pimpl->pause_ticks_));

  } else {
    // Đ
    return qrk::ticks() - pimpl->start_ticks_;
  }
}


bool StopWatch::isPause(void)
{
  return (pimpl->pause_ticks_ != pImpl::InvalidTicks) ? true : false;
}
